/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.Collection;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.PassThroughLineAggregator;

public class RecursiveCollectionLineAggregator<T>
implements LineAggregator<Collection<T>> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private LineAggregator<T> delegate = new PassThroughLineAggregator();

    public void setDelegate(LineAggregator<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String aggregate(Collection<T> items) {
        StringBuilder builder = new StringBuilder();
        for (T value : items) {
            builder.append(this.delegate.aggregate(value)).append(LINE_SEPARATOR);
        }
        return builder.delete(builder.length() - LINE_SEPARATOR.length(), builder.length()).toString();
    }
}

