/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.PassThroughFieldExtractor;
import org.springframework.util.Assert;

public abstract class ExtractorLineAggregator<T>
implements LineAggregator<T> {
    private FieldExtractor<T> fieldExtractor = new PassThroughFieldExtractor();

    public void setFieldExtractor(FieldExtractor<T> fieldExtractor) {
        this.fieldExtractor = fieldExtractor;
    }

    @Override
    public String aggregate(T item) {
        Assert.notNull(item, (String)"Item is required");
        Object[] fields = this.fieldExtractor.extract(item);
        Object[] args = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            args[i] = fields[i] == null ? "" : fields[i];
        }
        return this.doAggregate(args);
    }

    protected abstract String doAggregate(Object[] var1);
}

