/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.jsr.item;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamSupport;
import org.springframework.util.Assert;
import org.springframework.util.SerializationUtils;

public abstract class CheckpointSupport
extends ItemStreamSupport {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String checkpointKey;

    public CheckpointSupport(String checkpointKey) {
        Assert.hasText((String)checkpointKey);
        this.checkpointKey = checkpointKey;
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        try {
            this.doOpen((Serializable)executionContext.get(this.getExecutionContextKey(this.checkpointKey)));
        }
        catch (Exception e) {
            throw new ItemStreamException(e);
        }
    }

    protected abstract void doOpen(Serializable var1) throws Exception;

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        try {
            executionContext.put(this.getExecutionContextKey(this.checkpointKey), this.deepCopy(this.doCheckpoint()));
        }
        catch (Exception e) {
            throw new ItemStreamException(e);
        }
    }

    protected abstract Serializable doCheckpoint() throws Exception;

    @Override
    public void close() throws ItemStreamException {
        try {
            this.doClose();
        }
        catch (Exception e) {
            throw new ItemStreamException(e);
        }
    }

    protected abstract void doClose() throws Exception;

    private Object deepCopy(Serializable orig) {
        Object obj = orig;
        try {
            obj = SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)orig));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to copy checkpoint object.  Updating the instance passed may cause side effects");
        }
        return obj;
    }
}

