/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.batch.item.adapter.DynamicMethodInvocationException;
import org.springframework.batch.item.adapter.HippyMethodInvoker;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public abstract class AbstractMethodInvokingDelegator<T>
implements InitializingBean {
    private Object targetObject;
    private String targetMethod;
    private Object[] arguments;

    protected T invokeDelegateMethod() throws Exception {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(this.arguments);
        return this.doInvoke(invoker);
    }

    protected T invokeDelegateMethodWithArgument(Object object) throws Exception {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(new Object[]{object});
        return this.doInvoke(invoker);
    }

    protected T invokeDelegateMethodWithArguments(Object[] args) throws Exception {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(args);
        return this.doInvoke(invoker);
    }

    private MethodInvoker createMethodInvoker(Object targetObject, String targetMethod) {
        HippyMethodInvoker invoker = new HippyMethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        invoker.setArguments(this.arguments);
        return invoker;
    }

    private T doInvoke(MethodInvoker invoker) throws Exception {
        try {
            invoker.prepare();
        }
        catch (ClassNotFoundException e) {
            throw new DynamicMethodInvocationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DynamicMethodInvocationException(e);
        }
        try {
            return (T)invoker.invoke();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new InvocationTargetThrowableWrapper(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DynamicMethodInvocationException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.targetObject);
        Assert.hasLength((String)this.targetMethod);
        Assert.state((boolean)this.targetClassDeclaresTargetMethod(), (String)"target class must declare a method with matching name and parameter types");
    }

    private boolean targetClassDeclaresTargetMethod() {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        Method[] memberMethods = invoker.getTargetClass().getMethods();
        Method[] declaredMethods = invoker.getTargetClass().getDeclaredMethods();
        ArrayList<Method> allMethods = new ArrayList<Method>();
        allMethods.addAll(Arrays.asList(memberMethods));
        allMethods.addAll(Arrays.asList(declaredMethods));
        String targetMethodName = invoker.getTargetMethod();
        for (Method method : allMethods) {
            if (!method.getName().equals(targetMethodName)) continue;
            Class<?>[] params = method.getParameterTypes();
            if (this.arguments == null) {
                return true;
            }
            if (this.arguments.length != params.length) continue;
            boolean argumentsMatchParameters = true;
            for (int j = 0; j < params.length; ++j) {
                if (this.arguments[j] == null || ClassUtils.isAssignableValue(params[j], (Object)this.arguments[j])) continue;
                argumentsMatchParameters = false;
            }
            if (!argumentsMatchParameters) continue;
            return true;
        }
        return false;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments == null ? null : Arrays.asList(arguments).toArray();
    }

    public static class InvocationTargetThrowableWrapper
    extends RuntimeException {
        public InvocationTargetThrowableWrapper(Throwable cause) {
            super(cause);
        }
    }
}

