/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.SynchronizedAttributeAccessor;

public class RepeatContextSupport
extends SynchronizedAttributeAccessor
implements RepeatContext {
    private RepeatContext parent;
    private int count;
    private volatile boolean completeOnly;
    private volatile boolean terminateOnly;
    private Map<String, Set<Runnable>> callbacks = new HashMap<String, Set<Runnable>>();

    public RepeatContextSupport(RepeatContext parent) {
        this.parent = parent;
    }

    public boolean isCompleteOnly() {
        return this.completeOnly;
    }

    public void setCompleteOnly() {
        this.completeOnly = true;
    }

    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    public void setTerminateOnly() {
        this.terminateOnly = true;
        this.setCompleteOnly();
    }

    public RepeatContext getParent() {
        return this.parent;
    }

    public synchronized void increment() {
        ++this.count;
    }

    public synchronized int getStartedCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            Set<Runnable> set = this.callbacks.get(name);
            if (set == null) {
                set = new HashSet<Runnable>();
                this.callbacks.put(name, set);
            }
            set.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashSet<Map.Entry<String, Set<Runnable>>> copy;
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            copy = new HashSet<Map.Entry<String, Set<Runnable>>>(this.callbacks.entrySet());
        }
        for (Map.Entry entry : copy) {
            for (Runnable callback : (Set)entry.getValue()) {
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (RuntimeException t) {
                    errors.add(t);
                }
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        throw (RuntimeException)errors.get(0);
    }
}

