/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.Iterator;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorItemReader<T>
implements ItemReader<T> {
    private final Iterator<T> iterator;

    public IteratorItemReader(Iterable<T> iterable) {
        Assert.notNull(iterable, (String)"Iterable argument cannot be null!");
        this.iterator = iterable.iterator();
    }

    public IteratorItemReader(Iterator<T> iterator) {
        Assert.notNull(iterator, (String)"Iterator argument cannot be null!");
        this.iterator = iterator;
    }

    @Override
    public T read() throws Exception, UnexpectedInputException, ParseException {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        return null;
    }
}

