/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.file.transform.AbstractLineTokenizer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedLineTokenizer
extends AbstractLineTokenizer {
    public static final char DELIMITER_TAB = '\t';
    public static final char DELIMITER_COMMA = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    private char delimiter;
    private char quoteCharacter = (char)34;
    private String quoteString;

    public DelimitedLineTokenizer() {
        this(',');
    }

    public DelimitedLineTokenizer(char delimiter) {
        Assert.state((delimiter != '\"' ? 1 : 0) != 0, (String)"[\"] is not allowed as delimiter for tokenizers.");
        this.delimiter = delimiter;
        this.setQuoteCharacter('\"');
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public final void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
        this.quoteString = "" + quoteCharacter;
    }

    @Override
    protected List<String> doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        char[] chars = line.toCharArray();
        boolean inQuoted = false;
        int lastCut = 0;
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            boolean isEnd;
            char currentChar = chars[i];
            boolean bl = isEnd = i == length - 1;
            if (this.isDelimiterCharacter(currentChar) && !inQuoted || isEnd) {
                int endPosition;
                int n = endPosition = isEnd ? length - lastCut : i - lastCut;
                if (isEnd && this.isDelimiterCharacter(currentChar)) {
                    --endPosition;
                }
                String value = null;
                value = this.maybeStripQuotes(new String(chars, lastCut, endPosition));
                tokens.add(value);
                if (isEnd && this.isDelimiterCharacter(currentChar)) {
                    tokens.add("");
                }
                lastCut = i + 1;
                continue;
            }
            if (!this.isQuoteCharacter(currentChar)) continue;
            inQuoted = !inQuoted;
        }
        return tokens;
    }

    private String maybeStripQuotes(String string) {
        String value = string.trim();
        if (this.isQuoted(value)) {
            int endLength = (value = StringUtils.replace((String)value, (String)("" + this.quoteCharacter + this.quoteCharacter), (String)("" + this.quoteCharacter))).length() - 1;
            if (endLength == 0) {
                endLength = 1;
            }
            value = value.substring(1, endLength);
        }
        return value;
    }

    private boolean isQuoted(String value) {
        return value.startsWith(this.quoteString) && value.endsWith(this.quoteString);
    }

    private boolean isDelimiterCharacter(char c) {
        return c == this.delimiter;
    }

    protected boolean isQuoteCharacter(char c) {
        return c == this.quoteCharacter;
    }
}

