/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;

public class OraclePagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateRowNumSqlQuery(this, false, this.buildRowNumClause(pageSize));
    }

    public String generateRemainingPagesQuery(int pageSize) {
        return SqlPagingQueryUtils.generateRowNumSqlQuery(this, true, this.buildRowNumClause(pageSize));
    }

    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int offset = page * pageSize;
        offset = offset == 0 ? 1 : offset;
        return SqlPagingQueryUtils.generateRowNumSqlQueryWithNesting(this, this.getSortKey(), false, "TMP_ROW_NUM = " + offset);
    }

    private String buildRowNumClause(int pageSize) {
        return "ROWNUM <= " + pageSize;
    }
}

