/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.List;
import java.util.ListIterator;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemWriter;

public class CompositeItemWriter
implements ItemWriter {
    private List delegates;

    public void setDelegates(List delegates) {
        this.delegates = delegates;
    }

    public void write(Object data) throws Exception {
        ListIterator iterator = this.delegates.listIterator();
        while (iterator.hasNext()) {
            ((ItemWriter)iterator.next()).write(data);
        }
    }

    public void clear() throws ClearFailedException {
        ListIterator iterator = this.delegates.listIterator();
        while (iterator.hasNext()) {
            ((ItemWriter)iterator.next()).clear();
        }
    }

    public void flush() throws FlushFailedException {
        ListIterator iterator = this.delegates.listIterator();
        while (iterator.hasNext()) {
            ((ItemWriter)iterator.next()).flush();
        }
    }
}

