/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import java.util.Comparator;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RangeArrayPropertyEditor
extends PropertyEditorSupport {
    private boolean forceDisjointRanges = false;

    public void setForceDisjointRanges(boolean forceDisjointRanges) {
        this.forceDisjointRanges = forceDisjointRanges;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String[] strRanges = text.split(",");
        Range[] ranges = new Range[strRanges.length];
        for (int i = 0; i < strRanges.length; ++i) {
            int min;
            String[] range = strRanges[i].split("-");
            if (range.length == 1 && StringUtils.hasText((String)range[0])) {
                min = Integer.parseInt(range[0].trim());
                ranges[i] = new Range(min);
                continue;
            }
            if (range.length == 2 && StringUtils.hasText((String)range[0]) && StringUtils.hasText((String)range[1])) {
                min = Integer.parseInt(range[0].trim());
                int max = Integer.parseInt(range[1].trim());
                ranges[i] = new Range(min, max);
                continue;
            }
            throw new IllegalArgumentException("Range[" + i + "]: range (" + strRanges[i] + ") is invalid");
        }
        this.setMaxValues(ranges);
        this.setValue(ranges);
    }

    public String getAsText() {
        Range[] ranges = (Range[])this.getValue();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ranges.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ranges[i]);
        }
        return sb.toString();
    }

    private void setMaxValues(Range[] ranges) {
        Range[] c = (Range[])ranges.clone();
        Arrays.sort(c, new Comparator(){

            public int compare(Object o1, Object o2) {
                Range c1 = (Range)o1;
                Range c2 = (Range)o2;
                return c1.getMin() - c2.getMin();
            }
        });
        for (int i = 0; i < c.length - 1; ++i) {
            if (c[i].hasMaxValue()) continue;
            c[i].setMax(c[i + 1].getMin() - 1);
        }
        if (this.forceDisjointRanges) {
            this.verifyRanges(c);
        }
    }

    private void verifyRanges(Range[] ranges) {
        for (int i = 1; i < ranges.length; ++i) {
            Assert.isTrue((ranges[i - 1].getMax() < ranges[i].getMin() ? 1 : 0) != 0, (String)("Ranges must be disjoint. Range[" + (i - 1) + "]: (" + ranges[i - 1] + ") Range[" + i + "]: (" + ranges[i] + ")"));
        }
    }
}

