/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.extensions.excel;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class IsoFormattingDateDataFormatter
extends DataFormatter {
    public IsoFormattingDateDataFormatter() {
    }

    public IsoFormattingDateDataFormatter(Locale locale) {
        super(locale);
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
        if (DateUtil.isADateFormat((int)formatIndex, (String)formatString) && DateUtil.isValidExcelDate((double)value)) {
            String formatToUse = this.determineFormat(formatIndex);
            return super.formatRawCellContents(value, formatIndex, formatToUse, use1904Windowing);
        }
        return super.formatRawCellContents(value, formatIndex, formatString, use1904Windowing);
    }

    public String formatCellValue(Cell cell, FormulaEvaluator evaluator, ConditionalFormattingEvaluator cfEvaluator) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA && this.useCachedValuesForFormulaCells()) {
            cellType = cell.getCachedFormulaResultType();
        }
        if (cellType != CellType.STRING && DateUtil.isCellDateFormatted((Cell)cell, (ConditionalFormattingEvaluator)cfEvaluator)) {
            String formatToUse = this.determineFormat(ExcelNumberFormat.from((Cell)cell, (ConditionalFormattingEvaluator)cfEvaluator).getIdx());
            LocalDateTime value = cell.getLocalDateTimeCellValue();
            return value != null ? value.format(DateTimeFormatter.ofPattern(formatToUse)) : "";
        }
        return super.formatCellValue(cell, evaluator, cfEvaluator);
    }

    private String determineFormat(int formatIndex) {
        if (formatIndex >= 14 && formatIndex < 18) {
            return "yyyy-MM-dd";
        }
        if (formatIndex >= 18 && formatIndex < 22) {
            return "HH:mm:ss";
        }
        return "yyyy-MM-dd'T'HH:mm:ss";
    }
}

