/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbitmq.client;

import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.Management;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.DeclarableCustomizer;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueInformation;
import org.springframework.amqp.rabbit.core.DeclarationExceptionEvent;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbitmq.client.AmqpConnectionFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;

@ManagedResource(description="Admin Tasks")
public class RabbitAmqpAdmin
implements AmqpAdmin,
ApplicationContextAware,
ApplicationEventPublisherAware,
BeanNameAware,
SmartLifecycle {
    private static final LogAccessor LOG = new LogAccessor(RabbitAmqpAdmin.class);
    public static final String QUEUE_TYPE = "QUEUE_TYPE";
    private final AmqpConnectionFactory connectionFactory;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private boolean ignoreDeclarationExceptions;
    private @Nullable ApplicationContext applicationContext;
    private @Nullable ApplicationEventPublisher applicationEventPublisher;
    private String beanName;
    private boolean explicitDeclarationsOnly;
    private boolean autoStartup = true;
    private volatile @Nullable DeclarationExceptionEvent lastDeclarationExceptionEvent;
    private volatile boolean running = false;

    public RabbitAmqpAdmin(AmqpConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setIgnoreDeclarationExceptions(boolean ignoreDeclarationExceptions) {
        this.ignoreDeclarationExceptions = ignoreDeclarationExceptions;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"'taskExecutor' cannot be null");
        this.taskExecutor = taskExecutor;
    }

    public void setExplicitDeclarationsOnly(boolean explicitDeclarationsOnly) {
        this.explicitDeclarationsOnly = explicitDeclarationsOnly;
    }

    public @Nullable DeclarationExceptionEvent getLastDeclarationExceptionEvent() {
        return this.lastDeclarationExceptionEvent;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public void start() {
        if (!this.running) {
            this.initialize();
            this.running = true;
        }
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void initialize() {
        this.declareDeclarableBeans();
    }

    private void declareDeclarableBeans() {
        if (this.applicationContext == null) {
            LOG.debug((CharSequence)"no ApplicationContext has been set, cannot auto-declare Exchanges, Queues, and Bindings");
            return;
        }
        LOG.debug((CharSequence)"Initializing declarations");
        LinkedList<Exchange> contextExchanges = new LinkedList<Exchange>(this.applicationContext.getBeansOfType(Exchange.class).values());
        LinkedList<Queue> contextQueues = new LinkedList<Queue>(this.applicationContext.getBeansOfType(Queue.class).values());
        LinkedList<Binding> contextBindings = new LinkedList<Binding>(this.applicationContext.getBeansOfType(Binding.class).values());
        Collection<DeclarableCustomizer> customizers = this.applicationContext.getBeansOfType(DeclarableCustomizer.class).values();
        RabbitAmqpAdmin.processDeclarables(contextExchanges, contextQueues, contextBindings, this.applicationContext.getBeansOfType(Declarables.class, false, true).values());
        Collection<Exchange> exchanges = this.filterDeclarables(contextExchanges, customizers);
        Collection<Queue> queues = this.filterDeclarables(contextQueues, customizers);
        Collection<Binding> bindings = this.filterDeclarables(contextBindings, customizers);
        for (Exchange exchange2 : exchanges) {
            if (exchange2.isDurable() && !exchange2.isAutoDelete()) continue;
            LOG.info(() -> "Auto-declaring a non-durable or auto-delete Exchange (" + exchange2.getName() + ") durable:" + exchange2.isDurable() + ", auto-delete:" + exchange2.isAutoDelete() + ". It will be deleted by the broker if it shuts down, and can be redeclared by closing and reopening the connection.");
        }
        for (Queue queue2 : queues) {
            if (queue2.isDurable() && !queue2.isAutoDelete() && !queue2.isExclusive()) continue;
            LOG.info(() -> "Auto-declaring a non-durable, auto-delete, or exclusive Queue (" + queue2.getName() + ") durable:" + queue2.isDurable() + ", auto-delete:" + queue2.isAutoDelete() + ", exclusive:" + queue2.isExclusive() + ". It will be redeclared if the broker stops and is restarted while the connection factory is alive, but all messages will be lost.");
        }
        if (exchanges.isEmpty() && queues.isEmpty() && bindings.isEmpty()) {
            LOG.debug((CharSequence)"Nothing to declare");
            return;
        }
        try (Management management = this.getManagement();){
            exchanges.forEach(exchange -> this.doDeclareExchange(management, (Exchange)exchange));
            queues.forEach(queue -> this.doDeclareQueue(management, (Queue)queue));
            bindings.forEach(binding -> this.doDeclareBinding(management, (Binding)binding));
        }
        LOG.debug((CharSequence)"Declarations finished");
    }

    private <T extends Declarable> Collection<T> filterDeclarables(Collection<T> declarables, Collection<DeclarableCustomizer> customizers) {
        return declarables.stream().filter(dec -> dec.shouldDeclare() && this.declarableByMe(dec)).map(dec -> {
            if (customizers.isEmpty()) {
                return dec;
            }
            AtomicReference<Declarable> ref = new AtomicReference<Declarable>((Declarable)dec);
            customizers.forEach(cust -> ref.set((Declarable)cust.apply((Object)((Declarable)ref.get()))));
            return ref.get();
        }).toList();
    }

    private <T extends Declarable> boolean declarableByMe(T dec) {
        return dec.getDeclaringAdmins().isEmpty() && !this.explicitDeclarationsOnly || dec.getDeclaringAdmins().contains(this) || dec.getDeclaringAdmins().contains(this.beanName);
    }

    public void declareExchange(Exchange exchange) {
        try (Management management = this.getManagement();){
            this.doDeclareExchange(management, exchange);
        }
    }

    private void doDeclareExchange(Management management, Exchange exchange) {
        Management.ExchangeSpecification exchangeSpecification = management.exchange(exchange.getName()).type(exchange.isDelayed() ? "x-delayed-message" : exchange.getType()).arguments(exchange.getArguments()).autoDelete(exchange.isAutoDelete());
        if (exchange.isDelayed()) {
            exchangeSpecification.argument("x-delayed-type", (Object)exchange.getType());
        }
        try {
            exchangeSpecification.declare();
        }
        catch (AmqpException ex) {
            this.logOrRethrowDeclarationException((Declarable)exchange, "exchange", ex);
        }
    }

    @ManagedOperation(description="Delete an exchange from the broker")
    public boolean deleteExchange(String exchangeName) {
        if (RabbitAmqpAdmin.isDeletingDefaultExchange(exchangeName)) {
            return false;
        }
        try (Management management = this.getManagement();){
            management.exchangeDelete(exchangeName);
        }
        return true;
    }

    public @Nullable Queue declareQueue() {
        try (Management management = this.getManagement();){
            Queue queue = this.doDeclareQueue(management);
            return queue;
        }
    }

    private @Nullable Queue doDeclareQueue(Management management) {
        try {
            Management.QueueInfo queueInfo = management.queue().autoDelete(true).exclusive(true).classic().queue().declare();
            return new Queue(queueInfo.name(), false, true, true);
        }
        catch (AmqpException ex) {
            this.logOrRethrowDeclarationException(null, "queue", ex);
            return null;
        }
    }

    public @Nullable String declareQueue(Queue queue) {
        try (Management management = this.getManagement();){
            String string = this.doDeclareQueue(management, queue);
            return string;
        }
    }

    private @Nullable String doDeclareQueue(Management management, Queue queue) {
        Management.QueueSpecification queueSpecification = management.queue(queue.getName()).autoDelete(queue.isAutoDelete()).exclusive(queue.isExclusive()).arguments(queue.getArguments()).classic().queue();
        try {
            String actualName = queueSpecification.declare().name();
            queue.setActualName(actualName);
            return actualName;
        }
        catch (AmqpException ex) {
            this.logOrRethrowDeclarationException((Declarable)queue, "queue", ex);
            return null;
        }
    }

    @ManagedOperation(description="Delete a queue from the broker")
    public boolean deleteQueue(String queueName) {
        this.deleteQueue(queueName, false, false);
        return true;
    }

    @ManagedOperation(description="Delete a queue from the broker if unused and empty (when corresponding arguments are true")
    public void deleteQueue(String queueName, boolean unused, boolean empty) {
        try (Management management = this.getManagement();){
            Management.QueueInfo queueInfo = management.queueInfo(queueName);
            if (!(unused && queueInfo.consumerCount() != 0 || empty && queueInfo.messageCount() != 0L)) {
                management.queueDelete(queueName);
            }
        }
    }

    @ManagedOperation(description="Purge a queue and optionally don't wait for the purge to occur")
    public void purgeQueue(String queueName, boolean noWait) {
        if (noWait) {
            this.taskExecutor.execute(() -> this.purgeQueue(queueName));
        } else {
            this.purgeQueue(queueName);
        }
    }

    @ManagedOperation(description="Purge a queue and return the number of messages purged")
    public int purgeQueue(String queueName) {
        try (Management management = this.getManagement();){
            int n = (int)management.queuePurge(queueName).messageCount();
            return n;
        }
    }

    public void declareBinding(Binding binding) {
        try (Management management = this.getManagement();){
            this.doDeclareBinding(management, binding);
        }
    }

    private void doDeclareBinding(Management management, Binding binding) {
        try {
            Management.BindingSpecification bindingSpecification = management.binding().sourceExchange(binding.getExchange()).key(binding.getRoutingKey()).arguments(binding.getArguments());
            if (binding.isDestinationQueue()) {
                bindingSpecification.destinationQueue(binding.getDestination());
            } else {
                bindingSpecification.destinationExchange(binding.getDestination());
            }
            bindingSpecification.bind();
        }
        catch (AmqpException ex) {
            this.logOrRethrowDeclarationException((Declarable)binding, "binding", ex);
        }
    }

    public void removeBinding(Binding binding) {
        if (binding.isDestinationQueue() && RabbitAmqpAdmin.isRemovingImplicitQueueBinding(binding)) {
            return;
        }
        try (Management management = this.getManagement();){
            Management.UnbindSpecification unbindSpecification = management.unbind().sourceExchange(binding.getExchange()).key(binding.getRoutingKey()).arguments(binding.getArguments());
            if (binding.isDestinationQueue()) {
                unbindSpecification.destinationQueue(binding.getDestination());
            } else {
                unbindSpecification.destinationExchange(binding.getDestination());
            }
            unbindSpecification.unbind();
        }
    }

    @ManagedOperation(description="Get queue name, message count and consumer count")
    public @Nullable Properties getQueueProperties(String queueName) {
        QueueInformation queueInfo = this.getQueueInfo(queueName);
        if (queueInfo != null) {
            Properties props = new Properties();
            props.put(RabbitAdmin.QUEUE_NAME, queueInfo.getName());
            props.put(RabbitAdmin.QUEUE_MESSAGE_COUNT, (Object)queueInfo.getMessageCount());
            props.put(RabbitAdmin.QUEUE_CONSUMER_COUNT, (Object)queueInfo.getConsumerCount());
            props.put(QUEUE_TYPE, queueInfo.getType());
            return props;
        }
        return null;
    }

    public @Nullable QueueInformation getQueueInfo(String queueName) {
        try (Management management = this.getManagement();){
            Management.QueueInfo queueInfo = management.queueInfo(queueName);
            QueueInformation queueInformation = new QueueInformation(queueInfo.name(), queueInfo.messageCount(), queueInfo.consumerCount());
            queueInformation.setType(queueInfo.type().name().toLowerCase());
            QueueInformation queueInformation2 = queueInformation;
            return queueInformation2;
        }
    }

    private Management getManagement() {
        return this.connectionFactory.getConnection().management();
    }

    private <T extends Throwable> void logOrRethrowDeclarationException(@Nullable Declarable element, String elementType, T t) throws T {
        this.publishDeclarationExceptionEvent(element, t);
        if (this.ignoreDeclarationExceptions || element != null && element.isIgnoreDeclarationExceptions()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(t, (CharSequence)("Failed to declare " + elementType + ": " + String.valueOf(element == null ? "broker-generated" : element) + ", continuing..."));
            } else if (LOG.isWarnEnabled()) {
                Object cause = t;
                if (t instanceof IOException && t.getCause() != null) {
                    cause = t.getCause();
                }
                LOG.warn((CharSequence)("Failed to declare " + elementType + ": " + String.valueOf(element == null ? "broker-generated" : element) + ", continuing... " + String.valueOf(cause)));
            }
        } else {
            throw t;
        }
    }

    private void publishDeclarationExceptionEvent(@Nullable Declarable element, Throwable ex) {
        DeclarationExceptionEvent event;
        this.lastDeclarationExceptionEvent = event = new DeclarationExceptionEvent((Object)this, element, ex);
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    private static boolean isDeletingDefaultExchange(String exchangeName) {
        if (RabbitAmqpAdmin.isDefaultExchange(exchangeName)) {
            LOG.warn((CharSequence)"Default exchange cannot be deleted.");
            return true;
        }
        return false;
    }

    private static boolean isDefaultExchange(@Nullable String exchangeName) {
        return exchangeName == null || "".equals(exchangeName);
    }

    private static boolean isRemovingImplicitQueueBinding(Binding binding) {
        if (RabbitAmqpAdmin.isImplicitQueueBinding(binding)) {
            LOG.warn((CharSequence)"Cannot remove implicit default exchange binding to queue.");
            return true;
        }
        return false;
    }

    private static boolean isImplicitQueueBinding(Binding binding) {
        return RabbitAmqpAdmin.isDefaultExchange(binding.getExchange()) && Objects.equals(binding.getDestination(), binding.getRoutingKey());
    }

    private static void processDeclarables(Collection<Exchange> contextExchanges, Collection<Queue> contextQueues, Collection<Binding> contextBindings, Collection<Declarables> declarables) {
        declarables.forEach(d -> d.getDeclarables().forEach(declarable -> {
            if (declarable instanceof Exchange) {
                Exchange exch = (Exchange)declarable;
                contextExchanges.add(exch);
            } else if (declarable instanceof Queue) {
                Queue queue = (Queue)declarable;
                contextQueues.add(queue);
            } else if (declarable instanceof Binding) {
                Binding binding = (Binding)declarable;
                contextBindings.add(binding);
            }
        }));
    }
}

