/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.function.BiFunction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryOperations;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.core.retry.RetryTemplate;

public final class StatelessRetryOperationsInterceptor
implements MethodInterceptor {
    private final RetryOperations retryOperations;
    private final @Nullable BiFunction<@Nullable Object[], Throwable, @Nullable Object> recoverer;

    StatelessRetryOperationsInterceptor(@Nullable RetryPolicy retryPolicy, @Nullable BiFunction<@Nullable Object[], Throwable, @Nullable Object> recoverer) {
        this.retryOperations = new RetryTemplate(retryPolicy != null ? retryPolicy : RetryPolicy.builder().build());
        this.recoverer = recoverer;
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.retryOperations.execute(() -> ((MethodInvocation)invocation).proceed());
        }
        catch (RetryException ex) {
            if (this.recoverer != null) {
                return this.recoverer.apply(invocation.getArguments(), ex.getCause());
            }
            throw ex.getCause();
        }
    }
}

