/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.event.AmqpEvent;

public class ListenerContainerIdleEvent
extends AmqpEvent {
    private final long idleTime;
    private final @Nullable String listenerId;
    private final List<String> queueNames;

    public ListenerContainerIdleEvent(Object source, long idleTime, @Nullable String id, String ... queueNames) {
        super(source);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.queueNames = Arrays.asList(queueNames);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String[] getQueueNames() {
        return this.queueNames.toArray(new String[0]);
    }

    public @Nullable String getListenerId() {
        return this.listenerId;
    }

    public String toString() {
        return "ListenerContainerIdleEvent [idleTime=" + String.valueOf(Duration.ofMillis(this.idleTime)) + ", listenerId=" + this.listenerId + ", container=" + String.valueOf(this.getSource()) + "]";
    }
}

