/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Correlation;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.util.Assert;

public class CorrelationData
implements Correlation {
    private final CompletableFuture<Confirm> future = new CompletableFuture();
    private volatile String id;
    private volatile @Nullable ReturnedMessage returnedMessage;

    public CorrelationData() {
        this.id = UUID.randomUUID().toString();
    }

    public CorrelationData(String id) {
        Assert.notNull((Object)id, (String)"'id' cannot be null and must be unique");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Assert.notNull((Object)id, (String)"'id' cannot be null and must be unique");
        this.id = id;
    }

    public CompletableFuture<Confirm> getFuture() {
        return this.future;
    }

    public @Nullable ReturnedMessage getReturned() {
        return this.returnedMessage;
    }

    public void setReturned(ReturnedMessage returned) {
        this.returnedMessage = returned;
    }

    public String toString() {
        return "CorrelationData [id=" + this.id + "]";
    }

    public record Confirm(boolean ack, @Nullable String reason) {
        @Deprecated(forRemoval=true, since="4.0")
        public boolean isAck() {
            return this.ack;
        }

        @Deprecated(forRemoval=true, since="4.0")
        public @Nullable String getReason() {
            return this.reason;
        }
    }
}

