/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.batch;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.batch.MessageBatch;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

public class SimpleBatchingStrategy
implements BatchingStrategy {
    private final int batchSize;
    private final int bufferLimit;
    private final long timeout;
    private final List<Message> messages = new ArrayList<Message>();
    private String exchange;
    private String routingKey;
    private int currentSize;

    public SimpleBatchingStrategy(int batchSize, int bufferLimit, long timeout) {
        this.batchSize = batchSize;
        this.bufferLimit = bufferLimit;
        this.timeout = timeout;
    }

    @Override
    public MessageBatch addToBatch(String exch, String routKey, Message message) {
        if (this.exchange != null) {
            Assert.isTrue((boolean)this.exchange.equals(exch), (String)"Cannot send to different exchanges in the same batch");
        } else {
            this.exchange = exch;
        }
        if (this.routingKey != null) {
            Assert.isTrue((boolean)this.routingKey.equals(routKey), (String)"Cannot send with different routing keys in the same batch");
        } else {
            this.routingKey = routKey;
        }
        int bufferUse = 4 + message.getBody().length;
        MessageBatch batch = null;
        if (!this.messages.isEmpty() && this.currentSize + bufferUse > this.bufferLimit) {
            batch = this.doReleaseBatch();
            this.exchange = exch;
            this.routingKey = routKey;
        }
        this.currentSize += bufferUse;
        this.messages.add(message);
        if (batch == null && (this.messages.size() >= this.batchSize || this.currentSize >= this.bufferLimit)) {
            batch = this.doReleaseBatch();
        }
        return batch;
    }

    @Override
    public Date nextRelease() {
        if (this.messages.isEmpty() || this.timeout <= 0L) {
            return null;
        }
        if (this.currentSize >= this.bufferLimit) {
            return new Date();
        }
        return new Date(System.currentTimeMillis() + this.timeout);
    }

    @Override
    public Collection<MessageBatch> releaseBatches() {
        MessageBatch batch = this.doReleaseBatch();
        if (batch == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(batch);
    }

    private MessageBatch doReleaseBatch() {
        if (this.messages.isEmpty()) {
            return null;
        }
        Message message = this.assembleMessage();
        MessageBatch messageBatch = new MessageBatch(this.exchange, this.routingKey, message);
        this.messages.clear();
        this.currentSize = 0;
        this.exchange = null;
        this.routingKey = null;
        return messageBatch;
    }

    private Message assembleMessage() {
        if (this.messages.size() == 1) {
            return this.messages.get(0);
        }
        MessageProperties messageProperties = this.messages.get(0).getMessageProperties();
        byte[] body = new byte[this.currentSize];
        ByteBuffer bytes = ByteBuffer.wrap(body);
        for (Message message : this.messages) {
            bytes.putInt(message.getBody().length);
            bytes.put(message.getBody());
        }
        messageProperties.getHeaders().put("springBatchFormat", "lengthHeader4");
        messageProperties.getHeaders().put("amqp_batchSize", this.messages.size());
        return new Message(body, messageProperties);
    }

    @Override
    public boolean canDebatch(MessageProperties properties) {
        return "lengthHeader4".equals(properties.getHeaders().get("springBatchFormat"));
    }

    @Override
    public void deBatch(Message message, Consumer<Message> fragmentConsumer) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(message.getBody());
        MessageProperties messageProperties = message.getMessageProperties();
        messageProperties.getHeaders().remove("springBatchFormat");
        while (byteBuffer.hasRemaining()) {
            Message fragment;
            int length = byteBuffer.getInt();
            if (length < 0 || length > byteBuffer.remaining()) {
                throw new ListenerExecutionFailedException("Bad batched message received", new MessageConversionException("Insufficient batch data at offset " + byteBuffer.position()), message);
            }
            byte[] body = new byte[length];
            byteBuffer.get(body);
            messageProperties.setContentLength((long)length);
            if (byteBuffer.hasRemaining()) {
                fragment = new Message(body, messageProperties);
            } else {
                MessageProperties lastProperties = new MessageProperties();
                BeanUtils.copyProperties((Object)messageProperties, (Object)lastProperties);
                lastProperties.setLastInBatch(true);
                fragment = new Message(body, lastProperties);
            }
            fragmentConsumer.accept(fragment);
        }
    }
}

