/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.lang.Nullable;

public class PendingConfirm {
    static final long RETURN_CALLBACK_TIMEOUT = 60L;
    @Nullable
    private final CorrelationData correlationData;
    private final long timestamp;
    private final CountDownLatch latch = new CountDownLatch(1);
    private String cause;
    private boolean returned;

    public PendingConfirm(@Nullable CorrelationData correlationData, long timestamp) {
        this.correlationData = correlationData;
        this.timestamp = timestamp;
    }

    @Nullable
    public CorrelationData getCorrelationData() {
        return this.correlationData;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    @Nullable
    public String getCause() {
        return this.cause;
    }

    public boolean isReturned() {
        return this.returned;
    }

    public void setReturned(boolean isReturned) {
        this.returned = isReturned;
    }

    public boolean waitForReturnIfNeeded() throws InterruptedException {
        return !this.returned || this.latch.await(60L, TimeUnit.SECONDS);
    }

    public void countDown() {
        this.latch.countDown();
    }

    public String toString() {
        return "PendingConfirm [correlationData=" + this.correlationData + (String)(this.cause == null ? "" : " cause=" + this.cause) + "]";
    }
}

