/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.ShutdownSignalException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;

public class CompositeConnectionListener
implements ConnectionListener {
    private List<ConnectionListener> delegates = new CopyOnWriteArrayList<ConnectionListener>();

    @Override
    public void onCreate(Connection connection) {
        this.delegates.forEach(delegate -> delegate.onCreate(connection));
    }

    @Override
    public void onClose(Connection connection) {
        this.delegates.forEach(delegate -> delegate.onClose(connection));
    }

    @Override
    public void onShutDown(ShutdownSignalException signal) {
        this.delegates.forEach(delegate -> delegate.onShutDown(signal));
    }

    @Override
    public void onFailed(Exception exception) {
        this.delegates.forEach(delegate -> delegate.onFailed(exception));
    }

    public void setDelegates(List<? extends ConnectionListener> delegates) {
        this.delegates = new ArrayList<ConnectionListener>(delegates);
    }

    public void addDelegate(ConnectionListener delegate) {
        this.delegates.add(delegate);
    }

    public boolean removeDelegate(ConnectionListener delegate) {
        return this.delegates.remove(delegate);
    }

    public void clearDelegates() {
        this.delegates.clear();
    }
}

