/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.BindingInfo;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import com.rabbitmq.http.client.domain.QueueInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpManagementOperations;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;

@Deprecated
public class RabbitManagementTemplate
implements AmqpManagementOperations {
    private static final String DEFAULT_VHOST = "/";
    private final Client rabbitClient;

    public RabbitManagementTemplate() {
        this("http://localhost:15672/api/", "guest", "guest");
    }

    public RabbitManagementTemplate(Client rabbitClient) {
        this.rabbitClient = rabbitClient;
    }

    public RabbitManagementTemplate(String uri) {
        try {
            this.rabbitClient = new Client(uri);
        }
        catch (Exception e) {
            throw new AmqpException((Throwable)e);
        }
    }

    public RabbitManagementTemplate(String uri, String username, String password) {
        try {
            this.rabbitClient = new Client(uri, username, password);
        }
        catch (Exception e) {
            throw new AmqpException((Throwable)e);
        }
    }

    public Client getClient() {
        return this.rabbitClient;
    }

    public void addExchange(Exchange exchange) {
        this.addExchange(DEFAULT_VHOST, exchange);
    }

    public void addExchange(String vhost, Exchange exchange) {
        ExchangeInfo info = new ExchangeInfo();
        info.setArguments(exchange.getArguments());
        info.setAutoDelete(exchange.isAutoDelete());
        info.setDurable(exchange.isDurable());
        info.setType(exchange.getType());
        this.rabbitClient.declareExchange(vhost, exchange.getName(), info);
    }

    public void purgeQueue(Queue queue) {
        this.rabbitClient.purgeQueue(DEFAULT_VHOST, queue.getName());
    }

    public void purgeQueue(String vhost, Queue queue) {
        this.rabbitClient.purgeQueue(vhost, queue.getName());
    }

    public void deleteQueue(Queue queue) {
        this.rabbitClient.deleteQueue(DEFAULT_VHOST, queue.getName());
    }

    public void deleteQueue(String vhost, Queue queue) {
        this.rabbitClient.deleteQueue(vhost, queue.getName());
    }

    public Queue getQueue(String name) {
        return this.getQueue(DEFAULT_VHOST, name);
    }

    public Queue getQueue(String vhost, String name) {
        return this.convert(this.rabbitClient.getQueue(vhost, name));
    }

    public List<Queue> getQueues() {
        return this.convertQueueList(this.rabbitClient.getQueues());
    }

    public List<Queue> getQueues(String vhost) {
        return this.convertQueueList(this.rabbitClient.getQueues(vhost));
    }

    public void addQueue(Queue queue) {
        this.addQueue(DEFAULT_VHOST, queue);
    }

    public void addQueue(String vhost, Queue queue) {
        QueueInfo info = new QueueInfo();
        info.setArguments(queue.getArguments());
        info.setAutoDelete(queue.isAutoDelete());
        info.setDurable(queue.isDurable());
        info.setExclusive(queue.isExclusive());
        this.rabbitClient.declareQueue(vhost, queue.getName(), info);
    }

    public void deleteExchange(Exchange exchange) {
        this.deleteExchange(DEFAULT_VHOST, exchange);
    }

    public void deleteExchange(String vhost, Exchange exchange) {
        this.rabbitClient.deleteExchange(vhost, exchange.getName());
    }

    public Exchange getExchange(String name) {
        return this.getExchange(DEFAULT_VHOST, name);
    }

    public Exchange getExchange(String vhost, String name) {
        return this.convert(this.rabbitClient.getExchange(vhost, name));
    }

    public List<Exchange> getExchanges() {
        return this.convertExchangeList(this.rabbitClient.getExchanges());
    }

    public List<Exchange> getExchanges(String vhost) {
        return this.convertExchangeList(this.rabbitClient.getExchanges(vhost));
    }

    public List<Binding> getBindings() {
        return this.convertBindingList(this.rabbitClient.getBindings());
    }

    public List<Binding> getBindings(String vhost) {
        return this.convertBindingList(this.rabbitClient.getBindings(vhost));
    }

    public List<Binding> getBindingsForExchange(String vhost, String exchange) {
        return this.convertBindingList(this.rabbitClient.getBindingsBySource(vhost, exchange));
    }

    private List<Queue> convertQueueList(List<QueueInfo> queues) {
        return queues.stream().map(this::convert).collect(Collectors.toList());
    }

    private Queue convert(QueueInfo qi) {
        if (qi == null) {
            return null;
        }
        return new Queue(qi.getName(), qi.isDurable(), qi.isExclusive(), qi.isAutoDelete(), qi.getArguments());
    }

    private List<Exchange> convertExchangeList(List<ExchangeInfo> exchanges) {
        return exchanges.stream().map(this::convert).collect(Collectors.toList());
    }

    private Exchange convert(ExchangeInfo ei) {
        DirectExchange exchange;
        if (ei == null) {
            return null;
        }
        boolean delayed = false;
        if (ei.getType().equals("x-delayed-message")) {
            ei.setType((String)ei.getArguments().get("x-delayed-type"));
            delayed = true;
        }
        if (ei.getType().equals("direct")) {
            exchange = new DirectExchange(ei.getName(), ei.isDurable(), ei.isAutoDelete(), ei.getArguments());
        } else if (ei.getType().equals("fanout")) {
            exchange = new FanoutExchange(ei.getName(), ei.isDurable(), ei.isAutoDelete(), ei.getArguments());
        } else if (ei.getType().equals("headers")) {
            exchange = new HeadersExchange(ei.getName(), ei.isDurable(), ei.isAutoDelete(), ei.getArguments());
        } else if (ei.getType().equals("topic")) {
            exchange = new TopicExchange(ei.getName(), ei.isDurable(), ei.isAutoDelete(), ei.getArguments());
        } else {
            return null;
        }
        exchange.setDelayed(delayed);
        exchange.setInternal(ei.isInternal());
        return exchange;
    }

    private List<Binding> convertBindingList(List<BindingInfo> bindings) {
        return bindings.stream().map(this::convert).collect(Collectors.toList());
    }

    private Binding convert(BindingInfo bi) {
        if (bi == null) {
            return null;
        }
        return new Binding(bi.getDestination(), Binding.DestinationType.valueOf((String)bi.getDestinationType().toUpperCase()), bi.getSource(), bi.getRoutingKey(), bi.getArguments());
    }
}

