/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.RoutingConnectionFactory;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.ConditionalRejectingErrorHandler;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerFailedEvent;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerTerminatedEvent;
import org.springframework.amqp.rabbit.listener.ListenerContainerIdleEvent;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageRejectedWhileStoppingException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerExecutionException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.ConditionalExceptionLogger;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.postprocessor.MessagePostProcessorUtils;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public abstract class AbstractMessageListenerContainer
extends RabbitAccessor
implements MessageListenerContainer,
ApplicationContextAware,
BeanNameAware,
DisposableBean,
ApplicationEventPublisherAware {
    static final int DEFAULT_FAILED_DECLARATION_RETRY_INTERVAL = 5000;
    public static final boolean DEFAULT_DEBATCHING_ENABLED = true;
    public static final int DEFAULT_PREFETCH_COUNT = 250;
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 5000L;
    private final ContainerDelegate delegate = this::actualInvokeListener;
    protected final Object consumersMonitor = new Object();
    private final Map<String, Object> consumerArgs = new HashMap<String, Object>();
    private ContainerDelegate proxy = this.delegate;
    private long shutdownTimeout = 5000L;
    private ApplicationEventPublisher applicationEventPublisher;
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute = new DefaultTransactionAttribute();
    private String beanName;
    private Executor taskExecutor = new SimpleAsyncTaskExecutor();
    private boolean taskExecutorSet;
    private BackOff recoveryBackOff = new FixedBackOff(5000L, Long.MAX_VALUE);
    private MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private RabbitAdmin rabbitAdmin;
    private boolean missingQueuesFatal = true;
    private boolean missingQueuesFatalSet;
    private boolean possibleAuthenticationFailureFatal = true;
    private boolean possibleAuthenticationFailureFatalSet;
    private boolean autoDeclare = true;
    private boolean mismatchedQueuesFatal = false;
    private long failedDeclarationRetryInterval = 5000L;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private volatile boolean active = false;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();
    private volatile List<String> queueNames = new CopyOnWriteArrayList<String>();
    private ErrorHandler errorHandler = new ConditionalRejectingErrorHandler();
    private MessageConverter messageConverter;
    private boolean exposeListenerChannel = true;
    private volatile Object messageListener;
    private volatile AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
    private volatile boolean deBatchingEnabled = true;
    private volatile boolean initialized;
    private Collection<MessagePostProcessor> afterReceivePostProcessors;
    private volatile ApplicationContext applicationContext;
    private String listenerId;
    private Advice[] adviceChain = new Advice[0];
    private ConsumerTagStrategy consumerTagStrategy;
    private volatile boolean exclusive;
    private volatile boolean noLocal;
    private volatile boolean defaultRequeueRejected = true;
    private volatile int prefetchCount = 250;
    private long idleEventInterval;
    private volatile long lastReceive = System.currentTimeMillis();
    private boolean statefulRetryFatalWithNullMessageId = true;
    private ConditionalExceptionLogger exclusiveConsumerExceptionLogger = new DefaultExclusiveConsumerLogger();
    private boolean alwaysRequeueWithTxManagerRollback;
    private String lookupKeyQualifier = "";
    private boolean forceCloseChannel = true;
    private String errorHandlerLoggerName = this.getClass().getName();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public final void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setQueueNames(String ... queueName) {
        Assert.noNullElements((Object[])queueName, (String)"Queue name(s) cannot be null");
        this.queueNames = new CopyOnWriteArrayList<String>(queueName);
    }

    public final void setQueues(Queue ... queues) {
        this.setQueueNames(AbstractMessageListenerContainer.collectQueueNames(queues));
    }

    private static String[] collectQueueNames(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' cannot be null");
        Assert.noNullElements((Object[])queues, (String)"'queues' cannot contain null elements");
        String[] queueNames = new String[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            queueNames[i] = queues[i].getName();
        }
        return queueNames;
    }

    public String[] getQueueNames() {
        return this.queueNames.toArray(new String[this.queueNames.size()]);
    }

    protected Set<String> getQueueNamesAsSet() {
        return new HashSet<String>(this.queueNames);
    }

    public void addQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' cannot be null");
        Assert.noNullElements((Object[])queueNames, (String)"'queueNames' cannot contain null elements");
        this.queueNames.addAll(Arrays.asList(queueNames));
    }

    public final void addQueues(Queue ... queues) {
        this.addQueueNames(AbstractMessageListenerContainer.collectQueueNames(queues));
    }

    public boolean removeQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' cannot be null");
        Assert.noNullElements((Object[])queueNames, (String)"'queueNames' cannot contain null elements");
        return this.queueNames.removeAll(Arrays.asList(queueNames));
    }

    public final boolean removeQueues(Queue ... queues) {
        return this.removeQueueNames(AbstractMessageListenerContainer.collectQueueNames(queues));
    }

    public boolean isExposeListenerChannel() {
        return this.exposeListenerChannel;
    }

    public void setExposeListenerChannel(boolean exposeListenerChannel) {
        this.exposeListenerChannel = exposeListenerChannel;
    }

    public void setMessageListener(Object messageListener) {
        this.checkMessageListener(messageListener);
        this.messageListener = messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setChannelAwareMessageListener(ChannelAwareMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    protected void checkMessageListener(Object messageListener) {
        if (!(messageListener instanceof MessageListener) && !(messageListener instanceof ChannelAwareMessageListener)) {
            throw new IllegalArgumentException("Message listener needs to be of type [" + MessageListener.class.getName() + "] or [" + ChannelAwareMessageListener.class.getName() + "]");
        }
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Deprecated
    public void setMessageConverter(MessageConverter messageConverter) {
        this.logger.warn((Object)"It is preferred to configure the message converter via the endpoint. See RabbitListenerEndpoint.setMessageConverter");
        this.messageConverter = messageConverter;
    }

    @Override
    @Deprecated
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setDeBatchingEnabled(boolean deBatchingEnabled) {
        this.deBatchingEnabled = deBatchingEnabled;
    }

    public void setAdviceChain(Advice ... adviceChain) {
        this.adviceChain = Arrays.copyOf(adviceChain, adviceChain.length);
    }

    protected Advice[] getAdviceChain() {
        return this.adviceChain;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        Assert.notNull((Object)afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot be null");
        Assert.noNullElements((Object[])afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot have null elements");
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(afterReceivePostProcessors));
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected final String getBeanName() {
        return this.beanName;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory targetConnectionFactory;
        ConnectionFactory connectionFactory = super.getConnectionFactory();
        if (connectionFactory instanceof RoutingConnectionFactory && (targetConnectionFactory = ((RoutingConnectionFactory)((Object)connectionFactory)).getTargetConnectionFactory(this.getRoutingLookupKey())) != null) {
            return targetConnectionFactory;
        }
        return connectionFactory;
    }

    public void setLookupKeyQualifier(String lookupKeyQualifier) {
        this.lookupKeyQualifier = lookupKeyQualifier;
    }

    protected boolean isForceCloseChannel() {
        return this.forceCloseChannel;
    }

    public void setForceCloseChannel(boolean forceCloseChannel) {
        this.forceCloseChannel = forceCloseChannel;
    }

    protected String getRoutingLookupKey() {
        return super.getConnectionFactory() instanceof RoutingConnectionFactory ? this.lookupKeyQualifier + this.queueNames.toString().replaceAll(" ", "") : null;
    }

    protected RoutingConnectionFactory getRoutingConnectionFactory() {
        return super.getConnectionFactory() instanceof RoutingConnectionFactory ? (RoutingConnectionFactory)((Object)super.getConnectionFactory()) : null;
    }

    public String getListenerId() {
        return this.listenerId != null ? this.listenerId : this.beanName;
    }

    public void setListenerId(String listenerId) {
        this.listenerId = listenerId;
    }

    public void setConsumerTagStrategy(ConsumerTagStrategy consumerTagStrategy) {
        this.consumerTagStrategy = consumerTagStrategy;
    }

    protected ConsumerTagStrategy getConsumerTagStrategy() {
        return this.consumerTagStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumerArguments(Map<String, Object> args) {
        Object object = this.consumersMonitor;
        synchronized (object) {
            this.consumerArgs.clear();
            this.consumerArgs.putAll(args);
        }
    }

    protected Map<String, Object> getConsumerArguments() {
        return this.consumerArgs;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    protected boolean isExclusive() {
        return this.exclusive;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    protected boolean isNoLocal() {
        return this.noLocal;
    }

    public void setDefaultRequeueRejected(boolean defaultRequeueRejected) {
        this.defaultRequeueRejected = defaultRequeueRejected;
    }

    protected boolean isDefaultRequeueRejected() {
        return this.defaultRequeueRejected;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    protected int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    protected long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setIdleEventInterval(long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    protected long getIdleEventInterval() {
        return this.idleEventInterval;
    }

    protected long getLastReceive() {
        return this.lastReceive;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        Assert.notNull((Object)transactionAttribute, (String)"'transactionAttribute' cannot be null");
        this.transactionAttribute = transactionAttribute;
    }

    protected TransactionAttribute getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
        this.taskExecutorSet = true;
    }

    protected Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryBackOff = new FixedBackOff(recoveryInterval, Long.MAX_VALUE);
    }

    public void setRecoveryBackOff(BackOff recoveryBackOff) {
        Assert.notNull((Object)recoveryBackOff, (String)"'recoveryBackOff' must not be null.");
        this.recoveryBackOff = recoveryBackOff;
    }

    protected BackOff getRecoveryBackOff() {
        return this.recoveryBackOff;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        Assert.notNull((Object)messagePropertiesConverter, (String)"messagePropertiesConverter must not be null");
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    protected MessagePropertiesConverter getMessagePropertiesConverter() {
        return this.messagePropertiesConverter;
    }

    protected RabbitAdmin getRabbitAdmin() {
        return this.rabbitAdmin;
    }

    public final void setRabbitAdmin(RabbitAdmin rabbitAdmin) {
        this.rabbitAdmin = rabbitAdmin;
    }

    public void setMissingQueuesFatal(boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
        this.missingQueuesFatalSet = true;
    }

    protected boolean isMissingQueuesFatal() {
        return this.missingQueuesFatal;
    }

    protected boolean isMissingQueuesFatalSet() {
        return this.missingQueuesFatalSet;
    }

    public void setMismatchedQueuesFatal(boolean mismatchedQueuesFatal) {
        this.mismatchedQueuesFatal = mismatchedQueuesFatal;
    }

    protected boolean isMismatchedQueuesFatal() {
        return this.mismatchedQueuesFatal;
    }

    public void setPossibleAuthenticationFailureFatal(boolean possibleAuthenticationFailureFatal) {
        this.possibleAuthenticationFailureFatal = possibleAuthenticationFailureFatal;
        this.possibleAuthenticationFailureFatalSet = true;
    }

    public boolean isPossibleAuthenticationFailureFatal() {
        return this.possibleAuthenticationFailureFatal;
    }

    protected boolean isPossibleAuthenticationFailureFatalSet() {
        return this.possibleAuthenticationFailureFatalSet;
    }

    public void setAutoDeclare(boolean autoDeclare) {
        this.autoDeclare = autoDeclare;
    }

    protected boolean isAutoDeclare() {
        return this.autoDeclare;
    }

    public void setFailedDeclarationRetryInterval(long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    protected long getFailedDeclarationRetryInterval() {
        return this.failedDeclarationRetryInterval;
    }

    protected boolean isStatefulRetryFatalWithNullMessageId() {
        return this.statefulRetryFatalWithNullMessageId;
    }

    public void setStatefulRetryFatalWithNullMessageId(boolean statefulRetryFatalWithNullMessageId) {
        this.statefulRetryFatalWithNullMessageId = statefulRetryFatalWithNullMessageId;
    }

    public void setExclusiveConsumerExceptionLogger(ConditionalExceptionLogger exclusiveConsumerExceptionLogger) {
        this.exclusiveConsumerExceptionLogger = exclusiveConsumerExceptionLogger;
    }

    protected ConditionalExceptionLogger getExclusiveConsumerExceptionLogger() {
        return this.exclusiveConsumerExceptionLogger;
    }

    public void setAlwaysRequeueWithTxManagerRollback(boolean alwaysRequeueWithTxManagerRollback) {
        this.alwaysRequeueWithTxManagerRollback = alwaysRequeueWithTxManagerRollback;
    }

    protected boolean isAlwaysRequeueWithTxManagerRollback() {
        return this.alwaysRequeueWithTxManagerRollback;
    }

    public void setErrorHandlerLoggerName(String errorHandlerLoggerName) {
        Assert.notNull((Object)errorHandlerLoggerName, (String)"'errorHandlerLoggerName' cannot be null");
        this.errorHandlerLoggerName = errorHandlerLoggerName;
    }

    @Override
    public final void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state((this.exposeListenerChannel || !this.getAcknowledgeMode().isManual() ? 1 : 0) != 0, (String)"You cannot acknowledge messages manually if the channel is not exposed to the listener (please check your configuration and set exposeListenerChannel=true or acknowledgeMode!=MANUAL)");
        Assert.state((!this.getAcknowledgeMode().isAutoAck() || !this.isChannelTransacted() ? 1 : 0) != 0, (String)"The acknowledgeMode is NONE (autoack in Rabbit terms) which is not consistent with having a transactional channel. Either use a different AcknowledgeMode or make sure channelTransacted=false");
        this.validateConfiguration();
        this.initialize();
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.setMessageListener(messageListener);
    }

    protected void validateConfiguration() {
    }

    protected void initializeProxy(Object delegate) {
        if (this.getAdviceChain().length == 0) {
            return;
        }
        ProxyFactory factory = new ProxyFactory();
        for (Advice advice : this.getAdviceChain()) {
            factory.addAdvisor((Advisor)new DefaultPointcutAdvisor(advice));
        }
        factory.addInterface(ContainerDelegate.class);
        factory.setTarget(delegate);
        this.proxy = (ContainerDelegate)factory.getProxy(ContainerDelegate.class.getClassLoader());
    }

    public void destroy() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        try {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.lifecycleMonitor.notifyAll();
            }
            this.initializeProxy(this.delegate);
            this.checkMissingQueuesFatalFromProperty();
            this.checkPossibleAuthenticationFailureFatalFromProperty();
            this.doInitialize();
            if (!this.isExposeListenerChannel() && this.transactionManager != null) {
                this.logger.warn((Object)"exposeListenerChannel=false is ignored when using a TransactionManager");
            }
            if (!this.taskExecutorSet && StringUtils.hasText((String)this.getListenerId())) {
                this.taskExecutor = new SimpleAsyncTaskExecutor(this.getListenerId() + "-");
                this.taskExecutorSet = true;
            }
            if (this.transactionManager != null && !this.isChannelTransacted()) {
                this.logger.debug((Object)"The 'channelTransacted' is coerced to 'true', when 'transactionManager' is provided");
                this.setChannelTransacted(true);
            }
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isActive()) {
                this.logger.info((Object)"Shutdown ignored - container is not active already");
                return;
            }
            this.active = false;
            this.lifecycleMonitor.notifyAll();
        }
        this.logger.debug((Object)"Shutting down Rabbit listener container");
        try {
            this.doShutdown();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            Object object2 = this.lifecycleMonitor;
            synchronized (object2) {
                this.running = false;
                this.lifecycleMonitor.notifyAll();
            }
        }
    }

    protected abstract void doInitialize() throws Exception;

    protected abstract void doShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isActive() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (!this.initialized) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (!this.initialized) {
                    this.afterPropertiesSet();
                    this.initialized = true;
                }
            }
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting Rabbit listener container.");
            }
            this.configureAdminIfNeeded();
            this.checkMismatchedQueues();
            this.doStart();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.active = true;
            this.running = true;
            this.lifecycleMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.running = false;
                this.lifecycleMonitor.notifyAll();
            }
        }
    }

    public void stop(Runnable callback) {
        try {
            this.stop();
        }
        finally {
            callback.run();
        }
    }

    protected void doStop() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    protected void invokeErrorHandler(Throwable ex) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.handleError(ex);
            }
            catch (Exception e) {
                LogFactory.getLog((String)this.errorHandlerLoggerName).error((Object)"Execution of Rabbit message listener failed, and the error handler threw an exception", (Throwable)e);
                throw e;
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Execution of Rabbit message listener failed, and no ErrorHandler has been set.", ex);
        }
    }

    protected void executeListener(Channel channel, Message messageIn) throws Exception {
        if (!this.isRunning()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Rejecting received message because the listener container has been stopped: " + messageIn));
            }
            throw new MessageRejectedWhileStoppingException();
        }
        try {
            Object batchFormat;
            Message message = messageIn;
            if (this.afterReceivePostProcessors != null) {
                for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                    message = processor.postProcessMessage(message);
                    if (message != null) continue;
                    throw new ImmediateAcknowledgeAmqpException("Message Post Processor returned 'null', discarding message");
                }
            }
            if ("lengthHeader4".equals(batchFormat = message.getMessageProperties().getHeaders().get("springBatchFormat")) && this.deBatchingEnabled) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(message.getBody());
                MessageProperties messageProperties = message.getMessageProperties();
                messageProperties.getHeaders().remove("springBatchFormat");
                while (byteBuffer.hasRemaining()) {
                    int length = byteBuffer.getInt();
                    if (length < 0 || length > byteBuffer.remaining()) {
                        throw new ListenerExecutionFailedException("Bad batched message received", (Throwable)new MessageConversionException("Insufficient batch data at offset " + byteBuffer.position()), message);
                    }
                    byte[] body = new byte[length];
                    byteBuffer.get(body);
                    messageProperties.setContentLength((long)length);
                    Message fragment = new Message(body, messageProperties);
                    this.invokeListener(channel, fragment);
                }
            } else {
                this.invokeListener(channel, message);
            }
        }
        catch (Exception ex) {
            if (messageIn.getMessageProperties().isFinalRetryForMessageWithNoId()) {
                if (this.statefulRetryFatalWithNullMessageId) {
                    throw new FatalListenerExecutionException("Illegal null id in message. Failed to manage retry for message: " + messageIn);
                }
                throw new ListenerExecutionFailedException("Cannot retry message more than once without an ID", new AmqpRejectAndDontRequeueException("Not retryable; rejecting and not requeuing", (Throwable)ex), messageIn);
            }
            this.handleListenerException(ex);
            throw ex;
        }
    }

    protected void invokeListener(Channel channel, Message message) throws Exception {
        this.proxy.invokeListener(channel, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actualInvokeListener(Channel channel, Message message) throws Exception {
        Object listener = this.getMessageListener();
        if (listener instanceof ChannelAwareMessageListener) {
            this.doInvokeListener((ChannelAwareMessageListener)listener, channel, message);
        } else if (listener instanceof MessageListener) {
            boolean bindChannel;
            boolean bl = bindChannel = this.isExposeListenerChannel() && this.isChannelLocallyTransacted();
            if (bindChannel) {
                RabbitResourceHolder resourceHolder = new RabbitResourceHolder(channel, false);
                resourceHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)resourceHolder));
            }
            try {
                this.doInvokeListener((MessageListener)listener, message);
            }
            finally {
                if (bindChannel) {
                    TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                }
            }
        } else {
            if (listener != null) {
                throw new FatalListenerExecutionException("Only MessageListener and SessionAwareMessageListener supported: " + listener);
            }
            throw new FatalListenerExecutionException("No message listener specified - see property 'messageListener'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeListener(ChannelAwareMessageListener listener, Channel channel, Message message) throws Exception {
        RabbitResourceHolder resourceHolder = null;
        Channel channelToUse = channel;
        boolean boundHere = false;
        try {
            if (!this.isExposeListenerChannel()) {
                resourceHolder = this.getTransactionalResourceHolder();
                channelToUse = resourceHolder.getChannel();
                if (this.isChannelLocallyTransacted() && !TransactionSynchronizationManager.isActualTransactionActive()) {
                    resourceHolder.setSynchronizedWithTransaction(true);
                    TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)resourceHolder));
                    boundHere = true;
                }
            } else if (this.isChannelLocallyTransacted()) {
                RabbitResourceHolder localResourceHolder = new RabbitResourceHolder(channelToUse, false);
                localResourceHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)localResourceHolder));
                boundHere = true;
            }
            try {
                listener.onMessage(message, channelToUse);
            }
            catch (Exception e) {
                throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e, message);
            }
        }
        finally {
            if (resourceHolder != null && boundHere) {
                resourceHolder.setSynchronizedWithTransaction(false);
            }
            ConnectionFactoryUtils.releaseResources(resourceHolder);
            if (boundHere) {
                TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                if (!this.isExposeListenerChannel() && this.isChannelLocallyTransacted()) {
                    RabbitUtils.commitIfNecessary(channelToUse);
                }
            }
        }
    }

    protected void doInvokeListener(MessageListener listener, Message message) throws Exception {
        try {
            listener.onMessage(message);
        }
        catch (Exception e) {
            throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e, message);
        }
    }

    protected boolean isChannelLocallyTransacted() {
        return this.isChannelTransacted() && this.transactionManager == null;
    }

    protected void handleListenerException(Throwable ex) {
        if (this.isActive()) {
            this.invokeErrorHandler(ex);
        } else {
            this.logger.debug((Object)"Listener exception after container shutdown", ex);
        }
    }

    protected Exception wrapToListenerExecutionFailedExceptionIfNeeded(Exception e, Message message) {
        if (!(e instanceof ListenerExecutionFailedException)) {
            return new ListenerExecutionFailedException("Listener threw exception", e, message);
        }
        return e;
    }

    protected void publishConsumerFailedEvent(String reason, boolean fatal, Throwable t) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)(t == null ? new ListenerContainerConsumerTerminatedEvent(this, reason) : new ListenerContainerConsumerFailedEvent(this, reason, t, fatal)));
        }
    }

    protected final void publishIdleContainerEvent(long idleTime) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerContainerIdleEvent(this, idleTime, this.getListenerId(), this.getQueueNames()));
        }
    }

    protected void updateLastReceive() {
        if (this.idleEventInterval > 0L) {
            this.lastReceive = System.currentTimeMillis();
        }
    }

    protected void configureAdminIfNeeded() {
        if (this.rabbitAdmin == null && this.getApplicationContext() != null) {
            Map admins = this.getApplicationContext().getBeansOfType(RabbitAdmin.class);
            if (admins.size() == 1) {
                this.rabbitAdmin = (RabbitAdmin)admins.values().iterator().next();
            } else {
                if ((this.isAutoDeclare() || this.isMismatchedQueuesFatal()) && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("For 'autoDeclare' and 'mismatchedQueuesFatal' to work, there must be exactly one RabbitAdmin in the context or you must inject one into this container; found: " + admins.size() + " for container " + this.toString()));
                }
                if (this.isMismatchedQueuesFatal()) {
                    throw new IllegalStateException("When 'mismatchedQueuesFatal' is 'true', there must be exactly one RabbitAdmin in the context or you must inject one into this container; found: " + admins.size() + " for container " + this.toString());
                }
            }
        }
    }

    protected void checkMismatchedQueues() {
        if (this.mismatchedQueuesFatal && this.rabbitAdmin != null) {
            try {
                this.rabbitAdmin.initialize();
            }
            catch (AmqpConnectException e) {
                this.logger.info((Object)"Broker not available; cannot check queue declarations");
            }
            catch (AmqpIOException e) {
                if (RabbitUtils.isMismatchedQueueArgs((Exception)((Object)e))) {
                    throw new FatalListenerStartupException("Mismatched queues", e);
                }
                this.logger.info((Object)("Failed to get connection during start(): " + (Object)((Object)e)));
            }
        }
    }

    protected synchronized void redeclareElementsIfNecessary() {
        RabbitAdmin rabbitAdmin = this.getRabbitAdmin();
        if (rabbitAdmin == null || !this.isAutoDeclare()) {
            return;
        }
        try {
            ApplicationContext applicationContext = this.getApplicationContext();
            if (applicationContext != null) {
                Set<String> queueNames = this.getQueueNamesAsSet();
                Map queueBeans = applicationContext.getBeansOfType(Queue.class);
                for (Map.Entry entry : queueBeans.entrySet()) {
                    Queue queue = (Queue)entry.getValue();
                    if (!this.isMismatchedQueuesFatal() && (!queueNames.contains(queue.getName()) || rabbitAdmin.getQueueProperties(queue.getName()) != null)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Redeclaring context exchanges, queues, bindings.");
                    }
                    rabbitAdmin.initialize();
                    return;
                }
            }
        }
        catch (Exception e) {
            if (RabbitUtils.isMismatchedQueueArgs(e)) {
                throw new FatalListenerStartupException("Mismatched queues", e);
            }
            this.logger.error((Object)"Failed to check/redeclare auto-delete queue(s).", (Throwable)e);
        }
    }

    protected boolean causeChainHasImmediateAcknowledgeAmqpException(Throwable ex) {
        if (ex instanceof Error) {
            return false;
        }
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (cause instanceof ImmediateAcknowledgeAmqpException) {
                return true;
            }
            if (!(cause instanceof AmqpRejectAndDontRequeueException) && !(cause instanceof Error)) continue;
            return false;
        }
        return false;
    }

    protected void prepareHolderForRollback(RabbitResourceHolder resourceHolder, RuntimeException exception) {
        if (resourceHolder != null) {
            resourceHolder.setRequeueOnRollback(this.isAlwaysRequeueWithTxManagerRollback() || RabbitUtils.shouldRequeue(this.isDefaultRequeueRejected(), exception, this.logger));
        }
    }

    private void checkMissingQueuesFatalFromProperty() {
        if (!this.isMissingQueuesFatalSet()) {
            try {
                ApplicationContext applicationContext = this.getApplicationContext();
                if (applicationContext != null) {
                    Properties properties = (Properties)applicationContext.getBean("spring.amqp.global.properties", Properties.class);
                    String missingQueuesFatal = properties.getProperty("mlc.missing.queues.fatal");
                    if (!StringUtils.hasText((String)missingQueuesFatal)) {
                        missingQueuesFatal = properties.getProperty("smlc.missing.queues.fatal");
                    }
                    if (StringUtils.hasText((String)missingQueuesFatal)) {
                        this.setMissingQueuesFatal(Boolean.parseBoolean(missingQueuesFatal));
                    }
                }
            }
            catch (BeansException be) {
                this.logger.debug((Object)"No global properties bean");
            }
        }
    }

    private void checkPossibleAuthenticationFailureFatalFromProperty() {
        if (!this.isPossibleAuthenticationFailureFatal()) {
            try {
                Properties properties;
                String possibleAuthenticationFailureFatal;
                ApplicationContext applicationContext = this.getApplicationContext();
                if (applicationContext != null && StringUtils.hasText((String)(possibleAuthenticationFailureFatal = (properties = (Properties)applicationContext.getBean("spring.amqp.global.properties", Properties.class)).getProperty("mlc.possible.authentication.failure.fatal")))) {
                    this.setPossibleAuthenticationFailureFatal(Boolean.parseBoolean(possibleAuthenticationFailureFatal));
                }
            }
            catch (BeansException be) {
                this.logger.debug((Object)"No global properties bean");
            }
        }
    }

    private static class DefaultExclusiveConsumerLogger
    implements ConditionalExceptionLogger {
        DefaultExclusiveConsumerLogger() {
        }

        public void log(Log logger, String message, Throwable t) {
            if (t instanceof ShutdownSignalException) {
                ShutdownSignalException cause = (ShutdownSignalException)t;
                if (RabbitUtils.isExclusiveUseChannelClose(cause)) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(message + ": " + cause.toString()));
                    }
                } else if (!RabbitUtils.isNormalChannelClose(cause)) {
                    logger.error((Object)(message + ": " + cause.getMessage()));
                }
            } else if (logger.isErrorEnabled()) {
                logger.error((Object)("Unexpected invocation of " + this.getClass() + ", with message: " + message), t);
            }
        }
    }

    protected static final class WrappedTransactionException
    extends RuntimeException {
        protected WrappedTransactionException(Throwable cause) {
            super(cause);
        }
    }

    public static class SharedConnectionNotInitializedException
    extends RuntimeException {
        protected SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }

    @FunctionalInterface
    private static interface ContainerDelegate {
        public void invokeListener(Channel var1, Message var2) throws Exception;
    }
}

