/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TestRabbitTemplate
extends RabbitTemplate
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final String REPLY_QUEUE = "testRabbitTemplateReplyTo";
    private final Map<String, Listeners> listeners = new HashMap<String, Listeners>();
    private ApplicationContext applicationContext;
    @Autowired
    private RabbitListenerEndpointRegistry registry;

    public TestRabbitTemplate(ConnectionFactory connectionFactory) {
        super(connectionFactory);
        this.setReplyAddress(REPLY_QUEUE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        this.registry.getListenerContainers().stream().map(container -> (AbstractMessageListenerContainer)container).forEach(c -> {
            for (String queue : c.getQueueNames()) {
                this.setupListener((AbstractMessageListenerContainer)c, queue);
            }
        });
        this.applicationContext.getBeansOfType(AbstractMessageListenerContainer.class).values().stream().forEach(container -> {
            for (String queue : container.getQueueNames()) {
                this.setupListener((AbstractMessageListenerContainer)container, queue);
            }
        });
    }

    private void setupListener(AbstractMessageListenerContainer container, String queue) {
        this.listeners.computeIfAbsent(queue, v -> new Listeners()).listeners.add(container.getMessageListener());
    }

    protected boolean useDirectReplyTo() {
        return false;
    }

    protected void sendToRabbit(Channel channel, String exchange, String routingKey, boolean mandatory, Message message) throws IOException {
        Listeners listeners = this.listeners.get(routingKey);
        if (listeners == null) {
            throw new IllegalArgumentException("No listener for " + routingKey);
        }
        try {
            this.invoke(listeners.next(), message, channel);
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
        }
    }

    protected Message doSendAndReceiveWithFixed(String exchange, String routingKey, Message message, CorrelationData correlationData) {
        Listeners listeners = this.listeners.get(routingKey);
        if (listeners == null) {
            throw new IllegalArgumentException("No listener for " + routingKey);
        }
        Channel channel = (Channel)Mockito.mock(Channel.class);
        AtomicReference reply = new AtomicReference();
        Object listener = listeners.next();
        if (listener instanceof AbstractAdaptableMessageListener) {
            try {
                AbstractAdaptableMessageListener adapter = (AbstractAdaptableMessageListener)listener;
                ((Channel)BDDMockito.willAnswer(i -> {
                    Envelope envelope = new Envelope(1L, false, "", REPLY_QUEUE);
                    reply.set(MessageBuilder.withBody((byte[])((byte[])i.getArgument(4))).andProperties(this.getMessagePropertiesConverter().toMessageProperties((AMQP.BasicProperties)i.getArgument(3), envelope, adapter.getEncoding())).build());
                    return null;
                }).given((Object)channel)).basicPublish(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (AMQP.BasicProperties)ArgumentMatchers.any(AMQP.BasicProperties.class), (byte[])ArgumentMatchers.any(byte[].class));
                message.getMessageProperties().setReplyTo(REPLY_QUEUE);
                adapter.onMessage(message, channel);
            }
            catch (Exception e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
            }
        } else {
            throw new IllegalStateException("sendAndReceive not supported for " + listener.getClass().getName());
        }
        return (Message)reply.get();
    }

    private void invoke(Object listener, Message message, Channel channel) {
        if (listener instanceof ChannelAwareMessageListener) {
            try {
                ((ChannelAwareMessageListener)listener).onMessage(message, channel);
            }
            catch (Exception e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
            }
        } else if (listener instanceof MessageListener) {
            ((MessageListener)listener).onMessage(message);
        } else {
            throw new IllegalStateException("Listener of type " + listener.getClass().getName() + " is not supported");
        }
    }

    private static class Listeners {
        private final List<Object> listeners = new ArrayList<Object>();
        private volatile Iterator<Object> iterator;

        Listeners() {
        }

        private synchronized Object next() {
            if (this.iterator == null || !this.iterator.hasNext()) {
                this.iterator = this.listeners.iterator();
            }
            return this.iterator.next();
        }
    }
}

