/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.retry;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageHandler;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.config.StatelessRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.rabbit.stream.retry.StreamMessageRecoverer;
import org.springframework.util.Assert;

public class StreamRetryOperationsInterceptorFactoryBean
extends StatelessRetryOperationsInterceptorFactoryBean {
    protected @Nullable Object recover(@Nullable Object[] args, Throwable cause) {
        StreamMessageRecoverer messageRecoverer = (StreamMessageRecoverer)this.getMessageRecoverer();
        Object arg = args[0];
        if (arg instanceof org.springframework.amqp.core.Message) {
            return super.recover(args, cause);
        }
        if (messageRecoverer == null) {
            this.logger.warn((Object)("Message(s) dropped on recovery: " + String.valueOf(arg)), cause);
        } else {
            Message message = (Message)arg;
            MessageHandler.Context context = (MessageHandler.Context)args[1];
            Assert.notNull((Object)message, (String)"Message must not be null");
            Assert.notNull((Object)context, (String)"Context must not be null");
            messageRecoverer.recover(message, context, cause);
        }
        return null;
    }

    public void setStreamMessageRecoverer(StreamMessageRecoverer messageRecoverer) {
        super.setMessageRecoverer((MessageRecoverer)messageRecoverer);
    }

    public void setMessageRecoverer(MessageRecoverer messageRecoverer) {
        throw new UnsupportedOperationException("Use setStreamMessageRecoverer() instead");
    }
}

