/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.listener;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Consumer;
import com.rabbitmq.stream.ConsumerBuilder;
import com.rabbitmq.stream.Environment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.lang.Nullable;
import org.springframework.rabbit.stream.listener.ConsumerCustomizer;
import org.springframework.rabbit.stream.listener.StreamMessageListener;
import org.springframework.rabbit.stream.support.StreamMessageProperties;
import org.springframework.rabbit.stream.support.converter.DefaultStreamMessageConverter;
import org.springframework.rabbit.stream.support.converter.StreamMessageConverter;
import org.springframework.util.Assert;

public class StreamListenerContainer
implements MessageListenerContainer,
BeanNameAware {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final ConsumerBuilder builder;
    private StreamMessageConverter streamConverter;
    private ConsumerCustomizer consumerCustomizer = (id, con) -> {};
    private Consumer consumer;
    private String listenerId;
    private String beanName;
    private boolean autoStartup = true;
    private MessageListener messageListener;

    public StreamListenerContainer(Environment environment) {
        this(environment, null);
    }

    public StreamListenerContainer(Environment environment, @Nullable Codec codec) {
        Assert.notNull((Object)environment, (String)"'environment' cannot be null");
        this.builder = environment.consumerBuilder();
        this.streamConverter = new DefaultStreamMessageConverter(codec);
    }

    public void setQueueNames(String ... queueNames) {
        Assert.isTrue((queueNames != null && queueNames.length == 1 ? 1 : 0) != 0, (String)"Only one stream is supported");
        this.builder.stream(queueNames[0]);
    }

    public StreamMessageConverter getStreamConverter() {
        return this.streamConverter;
    }

    public void setStreamConverter(StreamMessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' cannot be null");
        this.streamConverter = messageConverter;
    }

    public synchronized void setConsumerCustomizer(ConsumerCustomizer consumerCustomizer) {
        Assert.notNull((Object)consumerCustomizer, (String)"'consumerCustomizer' cannot be null");
        this.consumerCustomizer = consumerCustomizer;
    }

    @Nullable
    public String getListenerId() {
        return this.listenerId != null ? this.listenerId : this.beanName;
    }

    public void setListenerId(String listenerId) {
        this.listenerId = listenerId;
    }

    @Nullable
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setAutoStartup(boolean autoStart) {
        this.autoStartup = autoStart;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Nullable
    public Object getMessageListener() {
        return this.messageListener;
    }

    public synchronized boolean isRunning() {
        return this.consumer != null;
    }

    public synchronized void start() {
        if (this.consumer == null) {
            this.consumerCustomizer.accept(this.getListenerId(), this.builder);
            this.consumer = this.builder.build();
        }
    }

    public synchronized void stop() {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
    }

    public void setupMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
        this.builder.messageHandler((context, message) -> {
            if (messageListener instanceof StreamMessageListener) {
                ((StreamMessageListener)messageListener).onStreamMessage(message, context);
            } else {
                Message message2 = this.streamConverter.toMessage((Object)message, new StreamMessageProperties(context));
                if (messageListener instanceof ChannelAwareMessageListener) {
                    try {
                        ((ChannelAwareMessageListener)messageListener).onMessage(message2, null);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Listner threw an exception", (Throwable)e);
                    }
                } else {
                    messageListener.onMessage(message2);
                }
            }
        });
    }
}

