/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.utils.test;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.util.Assert;

public final class TestUtils {
    private TestUtils() {
    }

    public static @Nullable Object getPropertyValue(Object root, String propertyPath) {
        Object value = null;
        DirectFieldAccessor accessor = new DirectFieldAccessor(root);
        String[] tokens = propertyPath.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            value = accessor.getPropertyValue(tokens[i]);
            if (value == null) {
                if (i == tokens.length - 1) {
                    return null;
                }
                throw new IllegalArgumentException("intermediate property '" + tokens[i] + "' is null");
            }
            accessor = new DirectFieldAccessor(value);
        }
        return value;
    }

    public static <T> @Nullable T getPropertyValue(Object root, String propertyPath, Class<T> type) {
        Object value = TestUtils.getPropertyValue(root, propertyPath);
        if (value != null) {
            Assert.isAssignable(type, value.getClass());
        }
        return (T)value;
    }
}

