/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.util.Assert;

public class MessageProperties
implements Serializable {
    private static final long serialVersionUID = 1619000546531112290L;
    public static final String CONTENT_TYPE_BYTES = "application/octet-stream";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_JSON_ALT = "text/x-json";
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String SPRING_BATCH_FORMAT = "springBatchFormat";
    public static final String BATCH_FORMAT_LENGTH_HEADER4 = "lengthHeader4";
    public static final String SPRING_AUTO_DECOMPRESS = "springAutoDecompress";
    public static final String X_DELAY = "x-delay";
    public static final String RETRY_COUNT = "retry-count";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final MessageDeliveryMode DEFAULT_DELIVERY_MODE = MessageDeliveryMode.PERSISTENT;
    public static final Integer DEFAULT_PRIORITY = 0;
    public static final long X_DELAY_MAX = 0xFFFFFFFFL;
    private final HashMap<String, @Nullable Object> headers = new HashMap();
    private @Nullable Date timestamp;
    private @Nullable String messageId;
    private @Nullable String userId;
    private @Nullable String appId;
    private @Nullable String clusterId;
    private @Nullable String type;
    private @Nullable String correlationId;
    private @Nullable String replyTo;
    private String contentType = "application/octet-stream";
    private @Nullable String contentEncoding;
    private long contentLength;
    private boolean contentLengthSet;
    private @Nullable MessageDeliveryMode deliveryMode = DEFAULT_DELIVERY_MODE;
    private @Nullable String expiration;
    private Integer priority = DEFAULT_PRIORITY;
    private @Nullable Boolean redelivered;
    private @Nullable String receivedExchange;
    private @Nullable String receivedRoutingKey;
    private @Nullable String receivedUserId;
    private long deliveryTag;
    private boolean deliveryTagSet;
    private @Nullable Integer messageCount;
    private @Nullable String consumerTag;
    private @Nullable String consumerQueue;
    private @Nullable Long receivedDelay;
    private @Nullable MessageDeliveryMode receivedDeliveryMode;
    private long retryCount;
    private boolean finalRetryForMessageWithNoId;
    private long publishSequenceNumber;
    private boolean lastInBatch;
    private boolean projectionUsed;
    private transient @Nullable Type inferredArgumentType;
    private transient @Nullable Method targetMethod;
    private transient @Nullable Object targetBean;

    public void setHeader(String key, Object value) {
        this.headers.put(key, value);
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers.putAll(headers);
    }

    public <T> @Nullable T getHeader(String headerName) {
        return (T)this.headers.get(headerName);
    }

    public Map<String, @Nullable Object> getHeaders() {
        return this.headers;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public @Nullable Date getTimestamp() {
        return this.timestamp;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public @Nullable String getMessageId() {
        return this.messageId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public @Nullable String getUserId() {
        return this.userId;
    }

    public @Nullable String getReceivedUserId() {
        return this.receivedUserId;
    }

    public void setReceivedUserId(String receivedUserId) {
        this.receivedUserId = receivedUserId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public @Nullable String getAppId() {
        return this.appId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public @Nullable String getClusterId() {
        return this.clusterId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public @Nullable String getType() {
        return this.type;
    }

    public void setCorrelationId(@Nullable String correlationId) {
        this.correlationId = correlationId;
    }

    public @Nullable String getCorrelationId() {
        return this.correlationId;
    }

    public void setReplyTo(@Nullable String replyTo) {
        this.replyTo = replyTo;
    }

    public @Nullable String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyToAddress(@Nullable Address replyTo) {
        this.replyTo = replyTo != null ? replyTo.toString() : null;
    }

    public @Nullable Address getReplyToAddress() {
        return this.replyTo != null ? new Address(this.replyTo) : null;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentEncoding(@Nullable String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public @Nullable String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
        this.contentLengthSet = true;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    protected final boolean isContentLengthSet() {
        return this.contentLengthSet;
    }

    public void setDeliveryMode(@Nullable MessageDeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public @Nullable MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public @Nullable MessageDeliveryMode getReceivedDeliveryMode() {
        return this.receivedDeliveryMode;
    }

    public void setReceivedDeliveryMode(MessageDeliveryMode receivedDeliveryMode) {
        this.receivedDeliveryMode = receivedDeliveryMode;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public @Nullable String getExpiration() {
        return this.expiration;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setReceivedExchange(String receivedExchange) {
        this.receivedExchange = receivedExchange;
    }

    public @Nullable String getReceivedExchange() {
        return this.receivedExchange;
    }

    public void setReceivedRoutingKey(String receivedRoutingKey) {
        this.receivedRoutingKey = receivedRoutingKey;
    }

    public @Nullable String getReceivedRoutingKey() {
        return this.receivedRoutingKey;
    }

    public @Nullable Long getReceivedDelayLong() {
        return this.receivedDelay;
    }

    public void setReceivedDelayLong(Long receivedDelay) {
        this.receivedDelay = receivedDelay;
    }

    public void setRedelivered(Boolean redelivered) {
        this.redelivered = redelivered;
    }

    public @Nullable Boolean isRedelivered() {
        return this.redelivered;
    }

    public @Nullable Boolean getRedelivered() {
        return this.redelivered;
    }

    public void setDeliveryTag(long deliveryTag) {
        this.deliveryTag = deliveryTag;
        this.deliveryTagSet = true;
    }

    public long getDeliveryTag() {
        return this.deliveryTag;
    }

    protected final boolean isDeliveryTagSet() {
        return this.deliveryTagSet;
    }

    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public @Nullable Integer getMessageCount() {
        return this.messageCount;
    }

    public @Nullable String getConsumerTag() {
        return this.consumerTag;
    }

    public void setConsumerTag(String consumerTag) {
        this.consumerTag = consumerTag;
    }

    public @Nullable String getConsumerQueue() {
        return this.consumerQueue;
    }

    public void setConsumerQueue(String consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    public @Nullable Long getDelayLong() {
        Object delay = this.headers.get(X_DELAY);
        if (delay instanceof Long) {
            Long delayLong = (Long)delay;
            return delayLong;
        }
        return null;
    }

    public void setDelayLong(@Nullable Long delay) {
        if (delay == null || delay < 0L) {
            this.headers.remove(X_DELAY);
            return;
        }
        Assert.isTrue((delay <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"Delay cannot exceed 4294967295");
        this.headers.put(X_DELAY, delay);
    }

    public long getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(long retryCount) {
        this.retryCount = retryCount;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public boolean isFinalRetryForMessageWithNoId() {
        return this.finalRetryForMessageWithNoId;
    }

    public void setFinalRetryForMessageWithNoId(boolean finalRetryForMessageWithNoId) {
        this.finalRetryForMessageWithNoId = finalRetryForMessageWithNoId;
    }

    public long getPublishSequenceNumber() {
        return this.publishSequenceNumber;
    }

    public void setPublishSequenceNumber(long publishSequenceNumber) {
        this.publishSequenceNumber = publishSequenceNumber;
    }

    public @Nullable Type getInferredArgumentType() {
        return this.inferredArgumentType;
    }

    public void setInferredArgumentType(Type inferredArgumentType) {
        this.inferredArgumentType = inferredArgumentType;
    }

    public @Nullable Method getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(@Nullable Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    public @Nullable Object getTargetBean() {
        return this.targetBean;
    }

    public void setTargetBean(@Nullable Object targetBean) {
        this.targetBean = targetBean;
    }

    public boolean isLastInBatch() {
        return this.lastInBatch;
    }

    public void setLastInBatch(boolean lastInBatch) {
        this.lastInBatch = lastInBatch;
    }

    public boolean isProjectionUsed() {
        return this.projectionUsed;
    }

    public void setProjectionUsed(boolean projectionUsed) {
        this.projectionUsed = projectionUsed;
    }

    public @Nullable List<Map<String, ?>> getXDeathHeader() {
        try {
            return (List)this.headers.get("x-death");
        }
        catch (Exception e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        result = 31 * result + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        result = 31 * result + (this.contentEncoding == null ? 0 : this.contentEncoding.hashCode());
        result = 31 * result + Long.hashCode(this.contentLength);
        result = 31 * result + this.contentType.hashCode();
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.deliveryMode == null ? 0 : this.deliveryMode.hashCode());
        result = 31 * result + Long.hashCode(this.deliveryTag);
        result = 31 * result + (this.expiration == null ? 0 : this.expiration.hashCode());
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + (this.messageCount == null ? 0 : this.messageCount.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = 31 * result + this.priority.hashCode();
        result = 31 * result + (this.receivedExchange == null ? 0 : this.receivedExchange.hashCode());
        result = 31 * result + (this.receivedRoutingKey == null ? 0 : this.receivedRoutingKey.hashCode());
        result = 31 * result + (this.redelivered == null ? 0 : this.redelivered.hashCode());
        result = 31 * result + (this.replyTo == null ? 0 : this.replyTo.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageProperties other = (MessageProperties)obj;
        if (this.appId == null ? other.appId != null : !this.appId.equals(other.appId)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.contentEncoding == null ? other.contentEncoding != null : !this.contentEncoding.equals(other.contentEncoding)) {
            return false;
        }
        if (this.contentLength != other.contentLength) {
            return false;
        }
        if (!this.contentType.equals(other.contentType)) {
            return false;
        }
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.deliveryMode != other.deliveryMode) {
            return false;
        }
        if (this.deliveryTag != other.deliveryTag) {
            return false;
        }
        if (this.expiration == null ? other.expiration != null : !this.expiration.equals(other.expiration)) {
            return false;
        }
        if (!this.headers.equals(other.headers)) {
            return false;
        }
        if (this.messageCount == null ? other.messageCount != null : !this.messageCount.equals(other.messageCount)) {
            return false;
        }
        if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
            return false;
        }
        if (!this.priority.equals(other.priority)) {
            return false;
        }
        if (this.receivedExchange == null ? other.receivedExchange != null : !this.receivedExchange.equals(other.receivedExchange)) {
            return false;
        }
        if (this.receivedRoutingKey == null ? other.receivedRoutingKey != null : !this.receivedRoutingKey.equals(other.receivedRoutingKey)) {
            return false;
        }
        if (this.redelivered == null ? other.redelivered != null : !this.redelivered.equals(other.redelivered)) {
            return false;
        }
        if (this.replyTo == null ? other.replyTo != null : !this.replyTo.equals(other.replyTo)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.userId == null) {
            return other.userId == null;
        }
        return this.userId.equals(other.userId);
    }

    public String toString() {
        return "MessageProperties [headers=" + String.valueOf(this.headers) + (String)(this.timestamp == null ? "" : ", timestamp=" + String.valueOf(this.timestamp)) + (String)(this.messageId == null ? "" : ", messageId=" + this.messageId) + (String)(this.userId == null ? "" : ", userId=" + this.userId) + (String)(this.receivedUserId == null ? "" : ", receivedUserId=" + this.receivedUserId) + (String)(this.appId == null ? "" : ", appId=" + this.appId) + (String)(this.clusterId == null ? "" : ", clusterId=" + this.clusterId) + (String)(this.type == null ? "" : ", type=" + this.type) + (String)(this.correlationId == null ? "" : ", correlationId=" + this.correlationId) + (String)(this.replyTo == null ? "" : ", replyTo=" + this.replyTo) + ", contentType=" + this.contentType + (String)(this.contentEncoding == null ? "" : ", contentEncoding=" + this.contentEncoding) + ", contentLength=" + this.contentLength + (String)(this.deliveryMode == null ? "" : ", deliveryMode=" + String.valueOf((Object)this.deliveryMode)) + (String)(this.receivedDeliveryMode == null ? "" : ", receivedDeliveryMode=" + String.valueOf((Object)this.receivedDeliveryMode)) + (String)(this.expiration == null ? "" : ", expiration=" + this.expiration) + ", priority=" + this.priority + (String)(this.redelivered == null ? "" : ", redelivered=" + this.redelivered) + (String)(this.receivedExchange == null ? "" : ", receivedExchange=" + this.receivedExchange) + (String)(this.receivedRoutingKey == null ? "" : ", receivedRoutingKey=" + this.receivedRoutingKey) + (String)(this.receivedDelay == null ? "" : ", receivedDelay=" + this.receivedDelay) + ", deliveryTag=" + this.deliveryTag + (String)(this.messageCount == null ? "" : ", messageCount=" + this.messageCount) + (String)(this.consumerTag == null ? "" : ", consumerTag=" + this.consumerTag) + (String)(this.consumerQueue == null ? "" : ", consumerQueue=" + this.consumerQueue) + "]";
    }
}

