/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;

public class ContentTypeDelegatingMessageConverter
implements MessageConverter {
    private final Map<String, MessageConverter> delegates = new HashMap<String, MessageConverter>();
    private final MessageConverter defaultConverter;

    public ContentTypeDelegatingMessageConverter() {
        this(new SimpleMessageConverter());
    }

    public ContentTypeDelegatingMessageConverter(MessageConverter defaultConverter) {
        this.defaultConverter = defaultConverter;
    }

    public void setDelegates(Map<String, MessageConverter> delegatesByContentType) {
        this.delegates.clear();
        this.delegates.putAll(delegatesByContentType);
    }

    public Map<String, MessageConverter> getDelegates() {
        return Collections.unmodifiableMap(this.delegates);
    }

    public void addDelegate(String contentType, MessageConverter messageConverter) {
        this.delegates.put(contentType, messageConverter);
    }

    public MessageConverter removeDelegate(String contentType) {
        return this.delegates.remove(contentType);
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        String contentType = message.getMessageProperties().getContentType();
        return this.getConverterForContentType(contentType).fromMessage(message);
    }

    @Override
    public Message toMessage(Object object, MessageProperties messageProperties) {
        String contentType = messageProperties.getContentType();
        return this.getConverterForContentType(contentType).toMessage(object, messageProperties);
    }

    protected MessageConverter getConverterForContentType(String contentType) {
        MessageConverter delegate = this.getDelegates().get(contentType);
        if (delegate == null) {
            delegate = this.defaultConverter;
        }
        if (delegate == null) {
            throw new MessageConversionException("No delegate converter is specified for content type " + contentType);
        }
        return delegate;
    }
}

