/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.zhipuai.api.ZhiPuAiStreamFunctionCallingHelper;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ZhiPuAiApi {
    public static final String DEFAULT_CHAT_MODEL = ChatModel.GLM_4_Air.getValue();
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingModel.Embedding_2.getValue();
    public static final String DEFAULT_EMBEDDINGS_PATH = "/v4/embeddings";
    public static final String DEFAULT_COMPLETIONS_PATH = "/v4/chat/completions";
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    private final String baseUrl;
    private final ApiKey apiKey;
    private final MultiValueMap<String, String> headers;
    private final String completionsPath;
    private final String embeddingsPath;
    private final ResponseErrorHandler responseErrorHandler;
    private final RestClient restClient;
    private final WebClient webClient;
    private final ZhiPuAiStreamFunctionCallingHelper chunkMerger = new ZhiPuAiStreamFunctionCallingHelper();

    public Builder mutate() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected ZhiPuAiApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, String completionsPath, String embeddingsPath, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Assert.hasText((String)completionsPath, (String)"Completions Path must not be null");
        Assert.hasText((String)embeddingsPath, (String)"Embeddings Path must not be null");
        Assert.notNull(headers, (String)"Headers must not be null");
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.headers = headers;
        this.completionsPath = completionsPath;
        this.embeddingsPath = embeddingsPath;
        this.responseErrorHandler = responseErrorHandler;
        Consumer<HttpHeaders> authHeaders = h -> {
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(headers);
        };
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(authHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(authHeaders).build();
    }

    public static String getTextContent(List<ChatCompletionMessage.MediaContent> content) {
        return content.stream().filter(c -> "text".equals(c.type())).map(ChatCompletionMessage.MediaContent::text).reduce("", (a, b) -> a + b);
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        return this.chatCompletionEntity(chatRequest, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest, MultiValueMap<String, String> additionalHttpHeader) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the stream property to false.");
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(this.completionsPath, new Object[0])).headers(headers -> {
            headers.addAll(additionalHttpHeader);
            this.addDefaultHeadersIfMissing((HttpHeaders)headers);
        })).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        return this.chatCompletionStream(chatRequest, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest, MultiValueMap<String, String> additionalHttpHeader) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the stream property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.completionsPath, new Object[0])).headers(headers -> {
            headers.addAll(additionalHttpHeader);
            this.addDefaultHeadersIfMissing((HttpHeaders)headers);
        })).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> (ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, ChatCompletionChunk.class)).map(chunk -> {
            if (this.chunkMerger.isStreamingToolFunctionCall((ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && this.chunkMerger.isStreamingToolFunctionCallFinish((ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatCompletionChunk(null, null, null, null, null, null, null), this.chunkMerger::merge);
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    public <T> ResponseEntity<EmbeddingList<Embedding>> embeddings(EmbeddingRequest<T> embeddingRequest) {
        Assert.notNull(embeddingRequest, (String)"The request body can not be null.");
        Assert.notNull(embeddingRequest.input(), (String)"The input can not be null.");
        Assert.isTrue((embeddingRequest.input() instanceof String || embeddingRequest.input() instanceof List ? 1 : 0) != 0, (String)"The input must be either a String, or a List of Strings or List of List of integers.");
        T t = embeddingRequest.input();
        if (t instanceof List) {
            List list = (List)t;
            Assert.isTrue((!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)"The input list can not be empty.");
            Assert.isTrue((list.size() <= 512 ? 1 : 0) != 0, (String)"The list must be 512 dimensions or less");
            Assert.isTrue((list.get(0) instanceof String || list.get(0) instanceof Integer || list.get(0) instanceof List ? 1 : 0) != 0, (String)"The input must be either a String, or a List of Strings or list of list of integers.");
        }
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(this.embeddingsPath, new Object[0])).headers(this::addDefaultHeadersIfMissing)).body(embeddingRequest).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<EmbeddingList<Embedding>>(){});
    }

    private void addDefaultHeadersIfMissing(HttpHeaders headers) {
        if (!headers.containsKey((Object)"Authorization") && !(this.apiKey instanceof NoopApiKey)) {
            headers.setBearerAuth(this.apiKey.getValue());
        }
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    ApiKey getApiKey() {
        return this.apiKey;
    }

    MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    String getCompletionsPath() {
        return this.completionsPath;
    }

    String getEmbeddingsPath() {
        return this.embeddingsPath;
    }

    ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public static final class Builder {
        private String baseUrl = "https://open.bigmodel.cn/api/paas";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private String completionsPath = "/v4/chat/completions";
        private String embeddingsPath = "/v4/embeddings";
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private WebClient.Builder webClientBuilder = WebClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        private Builder() {
        }

        public Builder(ZhiPuAiApi api) {
            this.baseUrl = api.getBaseUrl();
            this.apiKey = api.getApiKey();
            this.headers = new LinkedMultiValueMap(api.getHeaders());
            this.completionsPath = api.getCompletionsPath();
            this.embeddingsPath = api.getEmbeddingsPath();
            this.restClientBuilder = api.restClient != null ? api.restClient.mutate() : RestClient.builder();
            this.webClientBuilder = api.webClient != null ? api.webClient.mutate() : WebClient.builder();
            this.responseErrorHandler = api.getResponseErrorHandler();
        }

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder completionsPath(String completionsPath) {
            Assert.hasText((String)completionsPath, (String)"completionsPath cannot be null or empty");
            this.completionsPath = completionsPath;
            return this;
        }

        public Builder embeddingsPath(String embeddingsPath) {
            Assert.hasText((String)embeddingsPath, (String)"embeddingsPath cannot be null or empty");
            this.embeddingsPath = embeddingsPath;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder webClientBuilder(WebClient.Builder webClientBuilder) {
            Assert.notNull((Object)webClientBuilder, (String)"webClientBuilder cannot be null");
            this.webClientBuilder = webClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public ZhiPuAiApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new ZhiPuAiApi(this.baseUrl, this.apiKey, this.headers, this.completionsPath, this.embeddingsPath, this.restClientBuilder, this.webClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="model") String model, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="stop") List<String> stop, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice, @JsonProperty(value="user_id") String user, @JsonProperty(value="request_id") String requestId, @JsonProperty(value="do_sample") Boolean doSample, @JsonProperty(value="response_format") ResponseFormat responseFormat, @JsonProperty(value="thinking") Thinking thinking) {
        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature) {
            this(messages, model, null, null, false, temperature, null, null, null, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature, boolean stream) {
            this(messages, model, null, null, stream, temperature, null, null, null, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, List<FunctionTool> tools, Object toolChoice) {
            this(messages, model, null, null, false, 0.8, null, tools, toolChoice, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, Boolean stream) {
            this(messages, null, null, null, stream, null, null, null, null, null, null, null, null, null);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ResponseFormat(@JsonProperty(value="type") String type) {
            public static ResponseFormat text() {
                return new ResponseFormat("text");
            }

            public static ResponseFormat jsonObject() {
                return new ResponseFormat("json_object");
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Thinking(@JsonProperty(value="type") String type) {
            public static Thinking enabled() {
                return new Thinking("enabled");
            }

            public static Thinking disabled() {
                return new Thinking("disabled");
            }
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object function(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletion(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="message") ChatCompletionMessage message, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequest<T>(@JsonProperty(value="input") T input, @JsonProperty(value="model") String model, @JsonProperty(value="dimensions") Integer dimensions) {
        public EmbeddingRequest(T input) {
            this(input, DEFAULT_EMBEDDING_MODEL, null);
        }

        public EmbeddingRequest(T input, String model) {
            this(input, model, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionChunk(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<ChunkChoice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ChunkChoice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="delta") ChatCompletionMessage delta, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Usage(@JsonProperty(value="completion_tokens") Integer completionTokens, @JsonProperty(value="prompt_tokens") Integer promptTokens, @JsonProperty(value="total_tokens") Integer totalTokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") List<ToolCall> toolCalls, @JsonProperty(value="reasoning_content") String reasoningContent) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return null;
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            throw new IllegalStateException("The content is not a string!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ToolCall(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record MediaContent(@JsonProperty(value="type") String type, @JsonProperty(value="text") String text, @JsonProperty(value="image_url") ImageUrl imageUrl) {
            public MediaContent(String text) {
                this("text", text, null);
            }

            public MediaContent(ImageUrl imageUrl) {
                this("image_url", null, imageUrl);
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonIgnoreProperties(ignoreUnknown=true)
            public record ImageUrl(@JsonProperty(value="url") String url, @JsonProperty(value="detail") String detail) {
                public ImageUrl(String url) {
                    this(url, null);
                }
            }
        }
    }

    public static enum ChatModel implements ChatModelDescription
    {
        GLM_4_6("glm-4.6"),
        GLM_4_5("glm-4.5"),
        GLM_4_5_X("glm-4.5-x"),
        GLM_4_5_Air("glm-4.5-air"),
        GLM_4_5_AirX("glm-4.5-airx"),
        GLM_4_5V("glm-4.5v"),
        GLM_4_5_Flash("glm-4.5-flash"),
        GLM_Z1_Air("glm-z1-air"),
        GLM_Z1_AirX("glm-z1-airx"),
        GLM_Z1_Flash("glm-z1-flash"),
        GLM_Z1_FlashX("glm-z1-flashx"),
        GLM_4("GLM-4"),
        GLM_4V("glm-4v"),
        GLM_4_Air("glm-4-air"),
        GLM_4_AirX("glm-4-airx"),
        GLM_4_Flash("glm-4-flash"),
        GLM_3_Turbo("GLM-3-Turbo"),
        GLM_4_Thinking_FlashX("glm-4.1v-thinking-flashx"),
        GLM_4_Thinking_Flash("glm-4.1v-thinking-flash");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    public static enum EmbeddingModel {
        Embedding_2("Embedding-2"),
        Embedding_3("Embedding-3");

        public final String value;

        private EmbeddingModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record EmbeddingList<T>(@JsonProperty(value="object") String object, @JsonProperty(value="data") List<T> data, @JsonProperty(value="model") String model, @JsonProperty(value="usage") Usage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Embedding(@JsonProperty(value="index") Integer index, @JsonProperty(value="embedding") float[] embedding, @JsonProperty(value="object") String object) {
        public Embedding(Integer index, float[] embedding) {
            this(index, embedding, "embedding");
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record LogProbs(@JsonProperty(value="content") List<Content> content) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Content(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes, @JsonProperty(value="top_logprobs") List<TopLogProbs> topLogprobs) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonIgnoreProperties(ignoreUnknown=true)
            public record TopLogProbs(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes) {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FunctionTool {
        @JsonProperty(value="type")
        private Type type = Type.FUNCTION;
        @JsonProperty(value="function")
        private Function function;

        public FunctionTool() {
        }

        public FunctionTool(Type type, Function function) {
            this.type = type;
            this.function = function;
        }

        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        public Type getType() {
            return this.type;
        }

        public Function getFunction() {
            return this.function;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setFunction(Function function) {
            this.function = function;
        }

        public static enum Type {
            FUNCTION;

        }

        public static class Function {
            @JsonProperty(value="description")
            private String description;
            @JsonProperty(value="name")
            private String name;
            @JsonProperty(value="parameters")
            private Map<String, Object> parameters;
            @JsonIgnore
            private String jsonSchema;

            private Function() {
            }

            public Function(String description, String name, Map<String, Object> parameters) {
                this.description = description;
                this.name = name;
                this.parameters = parameters;
            }

            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema));
            }

            public String getDescription() {
                return this.description;
            }

            public String getName() {
                return this.name;
            }

            public Map<String, Object> getParameters() {
                return this.parameters;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setParameters(Map<String, Object> parameters) {
                this.parameters = parameters;
            }

            public String getJsonSchema() {
                return this.jsonSchema;
            }

            public void setJsonSchema(String jsonSchema) {
                this.jsonSchema = jsonSchema;
                if (jsonSchema != null) {
                    this.parameters = ModelOptionsUtils.jsonToMap((String)jsonSchema);
                }
            }
        }
    }

    public static enum ChatCompletionFinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        TOOL_CALL;

    }
}

