/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.zhipuai.api.ZhiPuAiImageApi;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZhiPuAiImageOptions
implements ImageOptions {
    @JsonProperty(value="model")
    private String model = ZhiPuAiImageApi.DEFAULT_IMAGE_MODEL;
    @JsonProperty(value="user_id")
    private String user;

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnore
    public Integer getN() {
        return null;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    @JsonIgnore
    public Integer getWidth() {
        return null;
    }

    @JsonIgnore
    public Integer getHeight() {
        return null;
    }

    @JsonIgnore
    public String getResponseFormat() {
        return null;
    }

    @JsonIgnore
    public String getStyle() {
        return null;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZhiPuAiImageOptions)) {
            return false;
        }
        ZhiPuAiImageOptions that = (ZhiPuAiImageOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.user);
    }

    public String toString() {
        return "ZhiPuAiImageOptions{model='" + this.model + "', user='" + this.user + "'}";
    }

    public static class Builder {
        private final ZhiPuAiImageOptions options = new ZhiPuAiImageOptions();

        private Builder() {
        }

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withUser(String user) {
            this.options.setUser(user);
            return this;
        }

        public ZhiPuAiImageOptions build() {
            return this.options;
        }
    }
}

