/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZhiPuAiChatOptions
implements FunctionCallingOptions,
ChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @NestedConfigurationProperty
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @NestedConfigurationProperty
    @JsonProperty(value="tools")
    private List<ZhiPuAiApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonProperty(value="user_id")
    private String user;
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="do_sample")
    private Boolean doSample;
    @NestedConfigurationProperty
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @NestedConfigurationProperty
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @NestedConfigurationProperty
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<ZhiPuAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<ZhiPuAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Boolean getDoSample() {
        return this.doSample;
    }

    public void setDoSample(Boolean doSample) {
        this.doSample = doSample;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functionNames) {
        this.functions = functionNames;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.maxTokens == null ? 0 : this.maxTokens.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        result = 31 * result + (this.temperature == null ? 0 : this.temperature.hashCode());
        result = 31 * result + (this.topP == null ? 0 : this.topP.hashCode());
        result = 31 * result + (this.tools == null ? 0 : this.tools.hashCode());
        result = 31 * result + (this.toolChoice == null ? 0 : this.toolChoice.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.proxyToolCalls == null ? 0 : this.proxyToolCalls.hashCode());
        result = 31 * result + (this.toolContext == null ? 0 : this.toolContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZhiPuAiChatOptions other = (ZhiPuAiChatOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.maxTokens == null ? other.maxTokens != null : !this.maxTokens.equals(other.maxTokens)) {
            return false;
        }
        if (this.stop == null ? other.stop != null : !this.stop.equals(other.stop)) {
            return false;
        }
        if (this.temperature == null ? other.temperature != null : !this.temperature.equals(other.temperature)) {
            return false;
        }
        if (this.topP == null ? other.topP != null : !this.topP.equals(other.topP)) {
            return false;
        }
        if (this.tools == null ? other.tools != null : !this.tools.equals(other.tools)) {
            return false;
        }
        if (this.toolChoice == null ? other.toolChoice != null : !this.toolChoice.equals(other.toolChoice)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        if (this.requestId == null ? other.requestId != null : !this.requestId.equals(other.requestId)) {
            return false;
        }
        if (this.doSample == null ? other.doSample != null : !this.doSample.equals(other.doSample)) {
            return false;
        }
        if (this.proxyToolCalls == null ? other.proxyToolCalls != null : !this.proxyToolCalls.equals(other.proxyToolCalls)) {
            return false;
        }
        return !(this.toolContext == null ? other.toolContext != null : !this.toolContext.equals(other.toolContext));
    }

    public ZhiPuAiChatOptions copy() {
        return ZhiPuAiChatOptions.fromOptions(this);
    }

    public static ZhiPuAiChatOptions fromOptions(ZhiPuAiChatOptions fromOptions) {
        return ZhiPuAiChatOptions.builder().withModel(fromOptions.getModel()).withMaxTokens(fromOptions.getMaxTokens()).withStop(fromOptions.getStop()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withTools(fromOptions.getTools()).withToolChoice(fromOptions.getToolChoice()).withUser(fromOptions.getUser()).withRequestId(fromOptions.getRequestId()).withDoSample(fromOptions.getDoSample()).withFunctionCallbacks(fromOptions.getFunctionCallbacks()).withFunctions(fromOptions.getFunctions()).withProxyToolCalls(fromOptions.getProxyToolCalls()).withToolContext(fromOptions.getToolContext()).build();
    }

    public static class Builder {
        protected ZhiPuAiChatOptions options;

        public Builder() {
            this.options = new ZhiPuAiChatOptions();
        }

        public Builder(ZhiPuAiChatOptions options) {
            this.options = options;
        }

        public Builder withModel(String model) {
            this.options.model = model;
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder withStop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder withTemperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder withTopP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder withTools(List<ZhiPuAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder withToolChoice(String toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder withUser(String user) {
            this.options.user = user;
            return this;
        }

        public Builder withRequestId(String requestId) {
            this.options.requestId = requestId;
            return this;
        }

        public Builder withDoSample(Boolean doSample) {
            this.options.doSample = doSample;
            return this;
        }

        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder withProxyToolCalls(Boolean proxyToolCalls) {
            this.options.proxyToolCalls = proxyToolCalls;
            return this;
        }

        public Builder withToolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public ZhiPuAiChatOptions build() {
            return this.options;
        }
    }
}

