/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.model.tool.StructuredOutputChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.util.json.schema.JsonSchemaGenerator;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatModel;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiSafetySetting;
import org.springframework.ai.vertexai.gemini.schema.JsonSchemaConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexAiGeminiChatOptions
implements ToolCallingChatOptions,
StructuredOutputChatOptions {
    @JsonProperty(value="stopSequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="logprobs")
    private Integer logprobs;
    @JsonProperty(value="responseLogprobs")
    private boolean responseLogprobs;
    @JsonProperty(value="topP")
    private Double topP;
    @JsonProperty(value="topK")
    private Integer topK;
    @JsonProperty(value="candidateCount")
    private Integer candidateCount;
    @JsonProperty(value="maxOutputTokens")
    private Integer maxOutputTokens;
    @JsonProperty(value="modelName")
    private String model;
    @JsonProperty(value="responseMimeType")
    private String responseMimeType;
    @JsonProperty(value="responseSchema")
    private String responseSchema;
    @JsonProperty(value="frequencyPenalty")
    private Double frequencyPenalty;
    @JsonProperty(value="presencePenalty")
    private Double presencePenalty;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private Boolean googleSearchRetrieval = false;
    @JsonIgnore
    private List<VertexAiGeminiSafetySetting> safetySettings = new ArrayList<VertexAiGeminiSafetySetting>();

    public static Builder builder() {
        return new Builder();
    }

    public static VertexAiGeminiChatOptions fromOptions(VertexAiGeminiChatOptions fromOptions) {
        VertexAiGeminiChatOptions options = new VertexAiGeminiChatOptions();
        options.setStopSequences(fromOptions.getStopSequences());
        options.setTemperature(fromOptions.getTemperature());
        options.setTopP(fromOptions.getTopP());
        options.setTopK(fromOptions.getTopK());
        options.setFrequencyPenalty(fromOptions.getFrequencyPenalty());
        options.setPresencePenalty(fromOptions.getPresencePenalty());
        options.setCandidateCount(fromOptions.getCandidateCount());
        options.setMaxOutputTokens(fromOptions.getMaxOutputTokens());
        options.setModel(fromOptions.getModel());
        options.setToolCallbacks(fromOptions.getToolCallbacks());
        options.setResponseMimeType(fromOptions.getResponseMimeType());
        options.setResponseSchema(fromOptions.getResponseSchema());
        options.setToolNames(fromOptions.getToolNames());
        options.setGoogleSearchRetrieval(fromOptions.getGoogleSearchRetrieval());
        options.setSafetySettings(fromOptions.getSafetySettings());
        options.setInternalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled());
        options.setToolContext(fromOptions.getToolContext());
        options.setLogprobs(fromOptions.getLogprobs());
        options.setResponseLogprobs(fromOptions.getResponseLogprobs());
        return options;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public void setResponseLogprobs(boolean responseLogprobs) {
        this.responseLogprobs = responseLogprobs;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Integer getCandidateCount() {
        return this.candidateCount;
    }

    public void setCandidateCount(Integer candidateCount) {
        this.candidateCount = candidateCount;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getMaxOutputTokens();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setMaxOutputTokens(maxTokens);
    }

    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public void setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String modelName) {
        this.model = modelName;
    }

    public String getResponseMimeType() {
        return this.responseMimeType;
    }

    public void setResponseMimeType(String mimeType) {
        this.responseMimeType = mimeType;
    }

    public String getResponseSchema() {
        return this.responseSchema;
    }

    public void setResponseSchema(String responseSchema) {
        this.responseSchema = responseSchema;
    }

    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    public Set<String> getToolNames() {
        return this.toolNames;
    }

    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Boolean getGoogleSearchRetrieval() {
        return this.googleSearchRetrieval;
    }

    public void setGoogleSearchRetrieval(Boolean googleSearchRetrieval) {
        this.googleSearchRetrieval = googleSearchRetrieval;
    }

    public List<VertexAiGeminiSafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    public void setSafetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
        Assert.notNull(safetySettings, (String)"safetySettings must not be null");
        this.safetySettings = safetySettings;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Integer logprobs) {
        this.logprobs = logprobs;
    }

    public boolean getResponseLogprobs() {
        return this.responseLogprobs;
    }

    public String getOutputSchema() {
        return this.getResponseSchema();
    }

    @JsonIgnore
    public void setOutputSchema(String jsonSchemaText) {
        ObjectNode jsonSchema = JsonSchemaConverter.fromJson(jsonSchemaText);
        ObjectNode openApiSchema = JsonSchemaConverter.convertToOpenApiSchema(jsonSchema);
        JsonSchemaGenerator.convertTypeValuesToUpperCase((ObjectNode)openApiSchema);
        this.setResponseSchema(openApiSchema.toPrettyString());
        this.setResponseMimeType("application/json");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VertexAiGeminiChatOptions)) {
            return false;
        }
        VertexAiGeminiChatOptions that = (VertexAiGeminiChatOptions)o;
        return this.googleSearchRetrieval == that.googleSearchRetrieval && Objects.equals(this.stopSequences, that.stopSequences) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.candidateCount, that.candidateCount) && Objects.equals(this.frequencyPenalty, that.frequencyPenalty) && Objects.equals(this.presencePenalty, that.presencePenalty) && Objects.equals(this.maxOutputTokens, that.maxOutputTokens) && Objects.equals(this.model, that.model) && Objects.equals(this.responseMimeType, that.responseMimeType) && Objects.equals(this.responseSchema, that.responseSchema) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.safetySettings, that.safetySettings) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.toolContext, that.toolContext) && Objects.equals(this.logprobs, that.logprobs) && Objects.equals(this.responseLogprobs, that.responseLogprobs);
    }

    public int hashCode() {
        return Objects.hash(this.stopSequences, this.temperature, this.topP, this.topK, this.candidateCount, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.model, this.responseMimeType, this.responseSchema, this.toolCallbacks, this.toolNames, this.googleSearchRetrieval, this.safetySettings, this.internalToolExecutionEnabled, this.toolContext, this.logprobs, this.responseLogprobs);
    }

    public String toString() {
        return "VertexAiGeminiChatOptions{stopSequences=" + String.valueOf(this.stopSequences) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", candidateCount=" + this.candidateCount + ", maxOutputTokens=" + this.maxOutputTokens + ", model='" + this.model + "', responseMimeType='" + this.responseMimeType + "', responseSchema='" + this.responseSchema + ", toolCallbacks=" + String.valueOf(this.toolCallbacks) + ", toolNames=" + String.valueOf(this.toolNames) + ", googleSearchRetrieval=" + this.googleSearchRetrieval + ", safetySettings=" + String.valueOf(this.safetySettings) + ", logProbs=" + this.logprobs + ", responseLogprobs=" + this.responseLogprobs + "}";
    }

    public VertexAiGeminiChatOptions copy() {
        return VertexAiGeminiChatOptions.fromOptions(this);
    }

    public static final class Builder {
        private VertexAiGeminiChatOptions options = new VertexAiGeminiChatOptions();

        public Builder stopSequences(List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder topP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.setFrequencyPenalty(frequencyPenalty);
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.setPresencePenalty(presencePenalty);
            return this;
        }

        public Builder candidateCount(Integer candidateCount) {
            this.options.setCandidateCount(candidateCount);
            return this;
        }

        public Builder maxOutputTokens(Integer maxOutputTokens) {
            this.options.setMaxOutputTokens(maxOutputTokens);
            return this;
        }

        public Builder model(String modelName) {
            this.options.setModel(modelName);
            return this;
        }

        public Builder model(VertexAiGeminiChatModel.ChatModel model) {
            this.options.setModel(model.getValue());
            return this;
        }

        public Builder responseMimeType(String mimeType) {
            Assert.notNull((Object)mimeType, (String)"mimeType must not be null");
            this.options.setResponseMimeType(mimeType);
            return this;
        }

        public Builder responseSchema(String responseSchema) {
            this.options.setResponseSchema(responseSchema);
            return this;
        }

        public Builder outputSchema(String outputSchema) {
            this.options.setOutputSchema(outputSchema);
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.toolCallbacks = toolCallbacks;
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"Tool names must not be null");
            this.options.toolNames = toolNames;
            return this;
        }

        public Builder toolName(String toolName) {
            Assert.hasText((String)toolName, (String)"Tool name must not be empty");
            this.options.toolNames.add(toolName);
            return this;
        }

        public Builder googleSearchRetrieval(boolean googleSearch) {
            this.options.googleSearchRetrieval = googleSearch;
            return this;
        }

        public Builder safetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
            Assert.notNull(safetySettings, (String)"safetySettings must not be null");
            this.options.safetySettings = safetySettings;
            return this;
        }

        public Builder internalToolExecutionEnabled(boolean internalToolExecutionEnabled) {
            this.options.internalToolExecutionEnabled = internalToolExecutionEnabled;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public Builder logprobs(Integer logprobs) {
            this.options.setLogprobs(logprobs);
            return this;
        }

        public Builder responseLogprobs(Boolean responseLogprobs) {
            this.options.setResponseLogprobs(responseLogprobs);
            return this;
        }

        public VertexAiGeminiChatOptions build() {
            return this.options;
        }
    }

    public static enum TransportType {
        GRPC,
        REST;

    }
}

