/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini.schema;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.util.json.schema.JsonSchemaGenerator;
import org.springframework.ai.vertexai.gemini.schema.JsonSchemaConverter;
import org.springframework.util.Assert;

public class VertexToolCallingManager
implements ToolCallingManager {
    private final ToolCallingManager delegateToolCallingManager;

    public VertexToolCallingManager(ToolCallingManager delegateToolCallingManager) {
        Assert.notNull((Object)delegateToolCallingManager, (String)"Delegate tool calling manager must not be null");
        this.delegateToolCallingManager = delegateToolCallingManager;
    }

    public List<ToolDefinition> resolveToolDefinitions(ToolCallingChatOptions chatOptions) {
        List toolDefinitions = this.delegateToolCallingManager.resolveToolDefinitions(chatOptions);
        return toolDefinitions.stream().map(td -> {
            ObjectNode jsonSchema = JsonSchemaConverter.fromJson(td.inputSchema());
            ObjectNode openApiSchema = JsonSchemaConverter.convertToOpenApiSchema(jsonSchema);
            JsonSchemaGenerator.convertTypeValuesToUpperCase((ObjectNode)openApiSchema);
            return ToolDefinition.builder().name(td.name()).description(td.description()).inputSchema(openApiSchema.toPrettyString()).build();
        }).toList();
    }

    public ToolExecutionResult executeToolCalls(Prompt prompt, ChatResponse chatResponse) {
        return this.delegateToolCallingManager.executeToolCalls(prompt, chatResponse);
    }
}

