/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.FunctionResponse;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.GoogleSearchRetrieval;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.Schema;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import com.google.cloud.vertexai.generativeai.PartMaker;
import com.google.cloud.vertexai.generativeai.ResponseStream;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.metadata.UsageUtils;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.LegacyToolCallingManager;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatOptions;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiConstants;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiSafetySetting;
import org.springframework.ai.vertexai.gemini.schema.VertexToolCallingManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class VertexAiGeminiChatModel
implements org.springframework.ai.chat.model.ChatModel,
DisposableBean {
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final VertexAI vertexAI;
    private final VertexAiGeminiChatOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final GenerationConfig generationConfig;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    @Deprecated
    public VertexAiGeminiChatModel(VertexAI vertexAI) {
        this(vertexAI, VertexAiGeminiChatOptions.builder().model(ChatModel.GEMINI_1_5_PRO).temperature(0.8).build());
    }

    @Deprecated
    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options) {
        this(vertexAI, options, null);
    }

    @Deprecated
    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver) {
        this(vertexAI, options, functionCallbackResolver, List.of());
    }

    @Deprecated
    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks) {
        this(vertexAI, options, functionCallbackResolver, toolFunctionCallbacks, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    @Deprecated
    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate) {
        this(vertexAI, options, functionCallbackResolver, toolFunctionCallbacks, retryTemplate, ObservationRegistry.NOOP);
    }

    @Deprecated
    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions options, FunctionCallbackResolver functionCallbackResolver, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(vertexAI, options, (ToolCallingManager)LegacyToolCallingManager.builder().functionCallbackResolver(functionCallbackResolver).functionCallbacks(toolFunctionCallbacks).build(), retryTemplate, observationRegistry);
        this.logger.warn("This constructor is deprecated and will be removed in the next milestone. Please use the new constructor accepting ToolCallingManager instead.");
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(vertexAI, defaultOptions, toolCallingManager, retryTemplate, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public VertexAiGeminiChatModel(VertexAI vertexAI, VertexAiGeminiChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)vertexAI, (String)"VertexAI must not be null");
        Assert.notNull((Object)defaultOptions, (String)"VertexAiGeminiChatOptions must not be null");
        Assert.notNull((Object)defaultOptions.getModel(), (String)"VertexAiGeminiChatOptions.modelName must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.notNull((Object)toolCallingManager, (String)"ToolCallingManager must not be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"ToolExecutionEligibilityPredicate must not be null");
        this.vertexAI = vertexAI;
        this.defaultOptions = defaultOptions;
        this.generationConfig = this.toGenerationConfig(defaultOptions);
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
        this.toolCallingManager = toolCallingManager instanceof VertexToolCallingManager ? toolCallingManager : new VertexToolCallingManager(toolCallingManager);
    }

    private static GeminiMessageType toGeminiMessageType(@NonNull MessageType type) {
        Assert.notNull((Object)type, (String)"Message type must not be null");
        switch (type) {
            case SYSTEM: 
            case USER: 
            case TOOL: {
                return GeminiMessageType.USER;
            }
            case ASSISTANT: {
                return GeminiMessageType.MODEL;
            }
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(type));
    }

    static List<Part> messageToGeminiParts(Message message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (systemMessage.getText() != null) {
                parts.add(Part.newBuilder().setText(systemMessage.getText()).build());
            }
            return parts;
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (userMessage.getText() != null) {
                parts.add(Part.newBuilder().setText(userMessage.getText()).build());
            }
            parts.addAll(VertexAiGeminiChatModel.mediaToParts(userMessage.getMedia()));
            return parts;
        }
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (StringUtils.hasText((String)assistantMessage.getText())) {
                parts.add(Part.newBuilder().setText(assistantMessage.getText()).build());
            }
            if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                parts.addAll(assistantMessage.getToolCalls().stream().map(toolCall -> Part.newBuilder().setFunctionCall(FunctionCall.newBuilder().setName(toolCall.name()).setArgs(VertexAiGeminiChatModel.jsonToStruct(toolCall.arguments())).build()).build()).toList());
            }
            return parts;
        }
        if (message instanceof ToolResponseMessage) {
            ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
            return toolResponseMessage.getResponses().stream().map(response -> Part.newBuilder().setFunctionResponse(FunctionResponse.newBuilder().setName(response.name()).setResponse(VertexAiGeminiChatModel.jsonToStruct(response.responseData())).build()).build()).toList();
        }
        throw new IllegalArgumentException("Gemini doesn't support message type: " + String.valueOf(message.getClass()));
    }

    private static List<Part> mediaToParts(Collection<Media> media) {
        ArrayList<Part> parts = new ArrayList<Part>();
        List<Part> mediaParts = media.stream().map(mediaData -> PartMaker.fromMimeTypeAndData((String)mediaData.getMimeType().toString(), (Object)mediaData.getData())).toList();
        if (!CollectionUtils.isEmpty(mediaParts)) {
            parts.addAll(mediaParts);
        }
        return parts;
    }

    private static String structToJson(Struct struct) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)struct);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Struct jsonToStruct(String json) {
        try {
            Struct.Builder structBuilder = Struct.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)structBuilder);
            return structBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Schema jsonToSchema(String json) {
        try {
            Schema.Builder schemaBuilder = Schema.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)schemaBuilder);
            return schemaBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    private ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(VertexAiGeminiConstants.PROVIDER_NAME).requestOptions(prompt.getOptions()).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> (ChatResponse)this.retryTemplate.execute(context -> {
            GeminiRequest geminiRequest = this.createGeminiRequest(prompt);
            GenerateContentResponse generateContentResponse = this.getContentResponse(geminiRequest);
            List generations = generateContentResponse.getCandidatesList().stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
            GenerateContentResponse.UsageMetadata usage = generateContentResponse.getUsageMetadata();
            DefaultUsage currentUsage = usage != null ? new DefaultUsage(Integer.valueOf(usage.getPromptTokenCount()), Integer.valueOf(usage.getCandidatesTokenCount())) : new EmptyUsage();
            Usage cumulativeUsage = UsageUtils.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata(cumulativeUsage));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        }));
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        VertexAiGeminiChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, VertexAiGeminiChatOptions.class);
            } else {
                runtimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, VertexAiGeminiChatOptions.class);
            }
        }
        VertexAiGeminiChatOptions requestOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, VertexAiGeminiChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.isInternalToolExecutionEnabled(), (Object)this.defaultOptions.isInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
            requestOptions.setGoogleSearchRetrieval((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getGoogleSearchRetrieval(), (Object)this.defaultOptions.getGoogleSearchRetrieval()));
            requestOptions.setSafetySettings((List)ModelOptionsUtils.mergeOption(runtimeOptions.getSafetySettings(), this.defaultOptions.getSafetySettings()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.isInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
            requestOptions.setGoogleSearchRetrieval(this.defaultOptions.getGoogleSearchRetrieval());
            requestOptions.setSafetySettings(this.defaultOptions.getSafetySettings());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(VertexAiGeminiConstants.PROVIDER_NAME).requestOptions(prompt.getOptions()).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            GeminiRequest request = this.createGeminiRequest(prompt);
            try {
                ResponseStream responseStream = request.model.generateContentStream(request.contents);
                Flux chatResponseFlux = Flux.fromStream((Stream)responseStream.stream()).switchMap(response -> {
                    List generations = response.getCandidatesList().stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
                    GenerateContentResponse.UsageMetadata usage = response.getUsageMetadata();
                    EmptyUsage currentUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
                    Usage cumulativeUsage = UsageUtils.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
                    ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata(cumulativeUsage));
                    return Flux.just((Object)chatResponse);
                });
                Flux flux = chatResponseFlux.flatMap(response -> {
                    if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
                        return Flux.defer(() -> {
                            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
                            if (toolExecutionResult.returnDirect()) {
                                return Flux.just((Object)ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                            }
                            return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), (ChatResponse)response);
                        }).subscribeOn(Schedulers.boundedElastic());
                    }
                    return Flux.just((Object)response);
                }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate content", e);
            }
        });
    }

    protected List<Generation> responseCandidateToGeneration(Candidate candidate) {
        int candidateIndex = candidate.getIndex();
        Candidate.FinishReason candidateFinishReason = candidate.getFinishReason();
        Map<String, Candidate.FinishReason> messageMetadata = Map.of("candidateIndex", candidateIndex, "finishReason", candidateFinishReason);
        ChatGenerationMetadata chatGenerationMetadata = ChatGenerationMetadata.builder().finishReason(candidateFinishReason.name()).build();
        boolean isFunctionCall = candidate.getContent().getPartsList().stream().allMatch(Part::hasFunctionCall);
        if (isFunctionCall) {
            List<AssistantMessage.ToolCall> assistantToolCalls = candidate.getContent().getPartsList().stream().filter(part -> part.hasFunctionCall()).map(part -> {
                FunctionCall functionCall = part.getFunctionCall();
                String functionName = functionCall.getName();
                String functionArguments = VertexAiGeminiChatModel.structToJson(functionCall.getArgs());
                return new AssistantMessage.ToolCall("", "function", functionName, functionArguments);
            }).toList();
            AssistantMessage assistantMessage2 = new AssistantMessage("", messageMetadata, assistantToolCalls);
            return List.of(new Generation(assistantMessage2, chatGenerationMetadata));
        }
        List<Generation> generations = candidate.getContent().getPartsList().stream().map(part -> new AssistantMessage(part.getText(), messageMetadata)).map(assistantMessage -> new Generation(assistantMessage, chatGenerationMetadata)).toList();
        return generations;
    }

    private ChatResponseMetadata toChatResponseMetadata(Usage usage) {
        return ChatResponseMetadata.builder().usage(usage).build();
    }

    private DefaultUsage getDefaultUsage(GenerateContentResponse.UsageMetadata usageMetadata) {
        return new DefaultUsage(Integer.valueOf(usageMetadata.getPromptTokenCount()), Integer.valueOf(usageMetadata.getCandidatesTokenCount()), Integer.valueOf(usageMetadata.getTotalTokenCount()), (Object)usageMetadata);
    }

    private VertexAiGeminiChatOptions vertexAiGeminiChatOptions(Prompt prompt) {
        VertexAiGeminiChatOptions updatedRuntimeOptions = VertexAiGeminiChatOptions.builder().build();
        if (prompt.getOptions() != null) {
            updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, VertexAiGeminiChatOptions.class);
        }
        updatedRuntimeOptions = (VertexAiGeminiChatOptions)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)this.defaultOptions, VertexAiGeminiChatOptions.class);
        return updatedRuntimeOptions;
    }

    GeminiRequest createGeminiRequest(Prompt prompt) {
        VertexAiGeminiChatOptions options;
        ChatOptions chatOptions;
        VertexAiGeminiChatOptions requestOptions = (VertexAiGeminiChatOptions)prompt.getOptions();
        GenerativeModel.Builder generativeModelBuilder = new GenerativeModel.Builder().setVertexAi(this.vertexAI).setSafetySettings(this.toGeminiSafetySettings(requestOptions.getSafetySettings()));
        if (requestOptions.getModel() != null) {
            generativeModelBuilder.setModelName(requestOptions.getModel());
        } else {
            generativeModelBuilder.setModelName(this.defaultOptions.getModel());
        }
        GenerationConfig generationConfig = this.generationConfig;
        if (requestOptions != null) {
            generationConfig = this.toGenerationConfig(requestOptions);
        }
        ArrayList<Tool> tools = new ArrayList<Tool>();
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            List<FunctionDeclaration> functionDeclarations = toolDefinitions.stream().map(toolDefinition -> FunctionDeclaration.newBuilder().setName(toolDefinition.name()).setDescription(toolDefinition.description()).setParameters(VertexAiGeminiChatModel.jsonToSchema(toolDefinition.inputSchema())).build()).toList();
            tools.add(Tool.newBuilder().addAllFunctionDeclarations(functionDeclarations).build());
        }
        if ((chatOptions = prompt.getOptions()) instanceof VertexAiGeminiChatOptions && (options = (VertexAiGeminiChatOptions)chatOptions).getGoogleSearchRetrieval().booleanValue()) {
            GoogleSearchRetrieval googleSearchRetrieval = GoogleSearchRetrieval.newBuilder().getDefaultInstanceForType();
            Tool googleSearchRetrievalTool = Tool.newBuilder().setGoogleSearchRetrieval(googleSearchRetrieval).build();
            tools.add(googleSearchRetrievalTool);
        }
        if (!CollectionUtils.isEmpty(tools)) {
            generativeModelBuilder.setTools(tools);
        }
        if (!CollectionUtils.isEmpty(requestOptions.getSafetySettings())) {
            generativeModelBuilder.setSafetySettings(this.toGeminiSafetySettings(requestOptions.getSafetySettings()));
        }
        generativeModelBuilder.setGenerationConfig(generationConfig);
        GenerativeModel generativeModel = generativeModelBuilder.build();
        List<Content> contents = this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).toList());
        if (!CollectionUtils.isEmpty(contents)) {
            Assert.isTrue((contents.size() <= 1 ? 1 : 0) != 0, (String)"Only one system message is allowed in the prompt");
            generativeModel = generativeModel.withSystemInstruction(contents.get(0));
        }
        return new GeminiRequest(this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() != MessageType.SYSTEM).toList()), generativeModel);
    }

    private GenerationConfig toGenerationConfig(VertexAiGeminiChatOptions options) {
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.newBuilder();
        if (options.getTemperature() != null) {
            generationConfigBuilder.setTemperature(options.getTemperature().floatValue());
        }
        if (options.getMaxOutputTokens() != null) {
            generationConfigBuilder.setMaxOutputTokens(options.getMaxOutputTokens().intValue());
        }
        if (options.getTopK() != null) {
            generationConfigBuilder.setTopK((float)options.getTopK().intValue());
        }
        if (options.getTopP() != null) {
            generationConfigBuilder.setTopP(options.getTopP().floatValue());
        }
        if (options.getCandidateCount() != null) {
            generationConfigBuilder.setCandidateCount(options.getCandidateCount().intValue());
        }
        if (options.getStopSequences() != null) {
            generationConfigBuilder.addAllStopSequences(options.getStopSequences());
        }
        if (options.getResponseMimeType() != null) {
            generationConfigBuilder.setResponseMimeType(options.getResponseMimeType());
        }
        return generationConfigBuilder.build();
    }

    private List<Content> toGeminiContent(List<Message> instrucitons) {
        List<Content> contents = instrucitons.stream().map(message -> Content.newBuilder().setRole(VertexAiGeminiChatModel.toGeminiMessageType(message.getMessageType()).getValue()).addAllParts(VertexAiGeminiChatModel.messageToGeminiParts(message)).build()).toList();
        return contents;
    }

    private List<SafetySetting> toGeminiSafetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
        return safetySettings.stream().map(safetySetting -> SafetySetting.newBuilder().setCategoryValue(safetySetting.getCategory().getValue()).setThresholdValue(safetySetting.getThreshold().getValue()).setMethodValue(safetySetting.getMethod().getValue()).build()).toList();
    }

    GenerateContentResponse getContentResponse(GeminiRequest request) {
        try {
            return request.model.generateContent(request.contents);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate content", e);
        }
    }

    public ChatOptions getDefaultOptions() {
        return VertexAiGeminiChatOptions.fromOptions(this.defaultOptions);
    }

    public void destroy() throws Exception {
        if (this.vertexAI != null) {
            this.vertexAI.close();
        }
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ChatModel implements ChatModelDescription
    {
        GEMINI_PRO_VISION("gemini-pro-vision"),
        GEMINI_PRO("gemini-pro"),
        GEMINI_1_5_PRO("gemini-1.5-pro-002"),
        GEMINI_1_5_FLASH("gemini-1.5-flash-002"),
        GEMINI_1_5_FLASH_8B("gemini-1.5-flash-8b-001"),
        GEMINI_2_0_FLASH("gemini-2.0-flash"),
        GEMINI_2_0_FLASH_LIGHT("gemini-2.0-flash-lite"),
        GEMINI_2_5_PRO("gemini-2.5-pro-exp-03-28");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    public static enum GeminiMessageType {
        USER("user"),
        MODEL("model");

        public final String value;

        private GeminiMessageType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record GeminiRequest(List<Content> contents, GenerativeModel model) {
    }

    public static class Builder {
        private VertexAI vertexAI;
        private VertexAiGeminiChatOptions defaultOptions = VertexAiGeminiChatOptions.builder().temperature(0.7).topP(1.0).model(ChatModel.GEMINI_2_0_FLASH).build();
        private ToolCallingManager toolCallingManager;
        private ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate = new DefaultToolExecutionEligibilityPredicate();
        private FunctionCallbackResolver functionCallbackResolver;
        private List<FunctionCallback> toolFunctionCallbacks;
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder vertexAI(VertexAI vertexAI) {
            this.vertexAI = vertexAI;
            return this;
        }

        public Builder defaultOptions(VertexAiGeminiChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        public Builder toolExecutionEligibilityPredicate(ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
            this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
            return this;
        }

        @Deprecated
        public Builder functionCallbackResolver(FunctionCallbackResolver functionCallbackResolver) {
            this.functionCallbackResolver = functionCallbackResolver;
            return this;
        }

        @Deprecated
        public Builder toolFunctionCallbacks(List<FunctionCallback> toolFunctionCallbacks) {
            this.toolFunctionCallbacks = toolFunctionCallbacks;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public VertexAiGeminiChatModel build() {
            if (this.toolCallingManager != null) {
                Assert.isNull((Object)this.functionCallbackResolver, (String)"functionCallbackResolver cannot be set when toolCallingManager is set");
                Assert.isNull(this.toolFunctionCallbacks, (String)"toolFunctionCallbacks cannot be set when toolCallingManager is set");
                return new VertexAiGeminiChatModel(this.vertexAI, this.defaultOptions, this.toolCallingManager, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
            }
            if (this.functionCallbackResolver != null) {
                Assert.isNull((Object)this.toolCallingManager, (String)"toolCallingManager cannot be set when functionCallbackResolver is set");
                List<FunctionCallback> toolCallbacks = this.toolFunctionCallbacks != null ? this.toolFunctionCallbacks : List.of();
                return new VertexAiGeminiChatModel(this.vertexAI, this.defaultOptions, this.functionCallbackResolver, toolCallbacks, this.retryTemplate, this.observationRegistry);
            }
            return new VertexAiGeminiChatModel(this.vertexAI, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
        }
    }
}

