/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.embedding.text;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.vertexai.embedding.text.VertexAiTextEmbeddingModelName;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexAiTextEmbeddingOptions
implements EmbeddingOptions {
    public static final String DEFAULT_MODEL_NAME = VertexAiTextEmbeddingModelName.TEXT_EMBEDDING_004.getName();
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="task")
    private TaskType taskType;
    @JsonProperty(value="dimensions")
    private Integer dimensions;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="autoTruncate")
    private Boolean autoTruncate;

    public static Builder builder() {
        return new Builder();
    }

    public VertexAiTextEmbeddingOptions initializeDefaults() {
        if (this.getTaskType() == null) {
            this.setTaskType(TaskType.RETRIEVAL_DOCUMENT);
        }
        if (StringUtils.hasText((String)this.getTitle()) && this.getTaskType() != TaskType.RETRIEVAL_DOCUMENT) {
            throw new IllegalArgumentException("Title is only valid with task_type=RETRIEVAL_DOCUMENT");
        }
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String user) {
        this.title = user;
    }

    public Boolean getAutoTruncate() {
        return this.autoTruncate;
    }

    public void setAutoTruncate(Boolean autoTruncate) {
        this.autoTruncate = autoTruncate;
    }

    public static class Builder {
        protected VertexAiTextEmbeddingOptions options = new VertexAiTextEmbeddingOptions();

        public Builder from(VertexAiTextEmbeddingOptions fromOptions) {
            if (fromOptions.getDimensions() != null) {
                this.options.setDimensions(fromOptions.getDimensions());
            }
            if (StringUtils.hasText((String)fromOptions.getModel())) {
                this.options.setModel(fromOptions.getModel());
            }
            if (fromOptions.getTaskType() != null) {
                this.options.setTaskType(fromOptions.getTaskType());
            }
            if (StringUtils.hasText((String)fromOptions.getTitle())) {
                this.options.setTitle(fromOptions.getTitle());
            }
            return this;
        }

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withModel(VertexAiTextEmbeddingModelName model) {
            this.options.setModel(model.getName());
            return this;
        }

        public Builder withTaskType(TaskType taskType) {
            this.options.setTaskType(taskType);
            return this;
        }

        public Builder withDimensions(Integer dimensions) {
            this.options.dimensions = dimensions;
            return this;
        }

        public Builder withTitle(String user) {
            this.options.setTitle(user);
            return this;
        }

        public Builder withAutoTruncate(Boolean autoTruncate) {
            this.options.setAutoTruncate(autoTruncate);
            return this;
        }

        public VertexAiTextEmbeddingOptions build() {
            return this.options;
        }
    }

    public static enum TaskType {
        RETRIEVAL_QUERY,
        RETRIEVAL_DOCUMENT,
        SEMANTIC_SIMILARITY,
        CLASSIFICATION,
        CLUSTERING,
        QUESTION_ANSWERING,
        FACT_VERIFICATION;

    }
}

