/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.embedding;

import com.google.cloud.aiplatform.v1.EndpointName;
import com.google.cloud.aiplatform.v1.PredictionServiceSettings;
import java.io.IOException;
import org.springframework.util.StringUtils;

public class VertexAiEmbeddingConnectionDetails {
    private static final String DEFAULT_LOCATION = "us-central1";
    public static final String DEFAULT_ENDPOINT = "us-central1-aiplatform.googleapis.com:443";
    public static final String DEFAULT_ENDPOINT_SUFFIX = "-aiplatform.googleapis.com:443";
    public static final String DEFAULT_PUBLISHER = "google";
    private PredictionServiceSettings predictionServiceSettings;
    private final String projectId;
    private final String location;
    private final String publisher;

    public VertexAiEmbeddingConnectionDetails(String endpoint, String projectId, String location, String publisher) {
        this.projectId = projectId;
        this.location = location;
        this.publisher = publisher;
        try {
            this.predictionServiceSettings = ((PredictionServiceSettings.Builder)PredictionServiceSettings.newBuilder().setEndpoint(endpoint)).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public EndpointName getEndpointName(String modelName) {
        return EndpointName.ofProjectLocationPublisherModelName((String)this.projectId, (String)this.location, (String)this.publisher, (String)modelName);
    }

    public PredictionServiceSettings getPredictionServiceSettings() {
        return this.predictionServiceSettings;
    }

    public static class Builder {
        private String endpoint;
        private String projectId;
        private String location;
        private String publisher;

        public Builder withApiEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder withPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public VertexAiEmbeddingConnectionDetails build() {
            if (!StringUtils.hasText((String)this.endpoint)) {
                if (!StringUtils.hasText((String)this.location)) {
                    this.endpoint = VertexAiEmbeddingConnectionDetails.DEFAULT_ENDPOINT;
                    this.location = VertexAiEmbeddingConnectionDetails.DEFAULT_LOCATION;
                } else {
                    this.endpoint = this.location + VertexAiEmbeddingConnectionDetails.DEFAULT_ENDPOINT_SUFFIX;
                }
            }
            if (!StringUtils.hasText((String)this.publisher)) {
                this.publisher = VertexAiEmbeddingConnectionDetails.DEFAULT_PUBLISHER;
            }
            return new VertexAiEmbeddingConnectionDetails(this.endpoint, this.projectId, this.location, this.publisher);
        }
    }
}

