/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.testcontainers.service.connection.opensearch;

import org.springframework.ai.autoconfigure.vectorstore.opensearch.AwsOpenSearchConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.localstack.LocalStackContainer;

class AwsOpenSearchContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LocalStackContainer, AwsOpenSearchConnectionDetails> {
    AwsOpenSearchContainerConnectionDetailsFactory() {
    }

    public AwsOpenSearchConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LocalStackContainer> source) {
        return new AwsOpenSearchContainerConnectionDetails(source);
    }

    private static final class AwsOpenSearchContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LocalStackContainer>
    implements AwsOpenSearchConnectionDetails {
        private AwsOpenSearchContainerConnectionDetails(ContainerConnectionSource<LocalStackContainer> source) {
            super(source);
        }

        public String getRegion() {
            return ((LocalStackContainer)this.getContainer()).getRegion();
        }

        public String getAccessKey() {
            return ((LocalStackContainer)this.getContainer()).getAccessKey();
        }

        public String getSecretKey() {
            return ((LocalStackContainer)this.getContainer()).getSecretKey();
        }

        public String getHost(String domainName) {
            return "%s.%s.opensearch.localhost.localstack.cloud:%s".formatted(domainName, ((LocalStackContainer)this.getContainer()).getRegion(), ((LocalStackContainer)this.getContainer()).getMappedPort(4566));
        }
    }
}

