/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.docker.compose.service.connection.typesense;

import org.springframework.ai.autoconfigure.vectorstore.typesense.TypesenseConnectionDetails;
import org.springframework.ai.docker.compose.service.connection.typesense.TypesenseEnvironment;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

public class TypesenseDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<TypesenseConnectionDetails> {
    private static final int TYPESENSE_PORT = 8108;

    protected TypesenseDockerComposeConnectionDetailsFactory() {
        super("typesense/typesense", new String[0]);
    }

    protected TypesenseConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new TypesenseComposeConnectionDetails(source.getRunningService());
    }

    static class TypesenseComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements TypesenseConnectionDetails {
        private final TypesenseEnvironment environment;
        private final String host;
        private final int port;

        TypesenseComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new TypesenseEnvironment(service.env());
            this.host = service.host();
            this.port = service.ports().get(8108);
        }

        public String getHost() {
            return this.host;
        }

        public String getProtocol() {
            return "http";
        }

        public int getPort() {
            return this.port;
        }

        public String getApiKey() {
            return this.environment.getApiKey();
        }
    }
}

