/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.redis;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;
import org.springframework.ai.vectorstore.redis.RedisVectorStore;
import org.springframework.util.Assert;

public class RedisFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private final Map<String, RedisVectorStore.MetadataField> metadataFields;

    public RedisFilterExpressionConverter(List<RedisVectorStore.MetadataField> metadataFields) {
        this.metadataFields = metadataFields.stream().collect(Collectors.toMap(RedisVectorStore.MetadataField::name, Function.identity()));
    }

    protected void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    protected void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        context.append("@").append(key.key()).append(":");
    }

    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        switch (expression.type()) {
            case NIN: {
                this.doExpression(this.negate(Filter.ExpressionType.IN, expression), context);
                break;
            }
            case NE: {
                this.doExpression(this.negate(Filter.ExpressionType.EQ, expression), context);
                break;
            }
            case AND: {
                this.doBinaryOperation(" ", expression, context);
                break;
            }
            case OR: {
                this.doBinaryOperation(" | ", expression, context);
                break;
            }
            case NOT: {
                context.append("-");
                this.convertOperand(expression.left(), context);
                break;
            }
            default: {
                this.doField(expression, context);
            }
        }
    }

    private Filter.Expression negate(Filter.ExpressionType expressionType, Filter.Expression expression) {
        return new Filter.Expression(Filter.ExpressionType.NOT, (Filter.Operand)new Filter.Expression(expressionType, expression.left(), expression.right()), null);
    }

    private void doBinaryOperation(String delimiter, Filter.Expression expression, StringBuilder context) {
        Assert.state((expression.right() != null ? 1 : 0) != 0, (String)"expected an expression with a right operand");
        this.convertOperand(expression.left(), context);
        context.append(delimiter);
        this.convertOperand(expression.right(), context);
    }

    private void doField(Filter.Expression expression, StringBuilder context) {
        Filter.Key key = (Filter.Key)expression.left();
        this.doKey(key, context);
        RedisVectorStore.MetadataField field = this.metadataFields.getOrDefault(key.key(), RedisVectorStore.MetadataField.tag(key.key()));
        Filter.Value value = (Filter.Value)expression.right();
        Assert.state((value != null ? 1 : 0) != 0, (String)"expected an expression with a right operand");
        switch (field.fieldType()) {
            case NUMERIC: {
                Numeric numeric = this.numeric(expression, value);
                context.append("[");
                context.append(numeric.lower());
                context.append(" ");
                context.append(numeric.upper());
                context.append("]");
                break;
            }
            case TAG: {
                context.append("{");
                context.append(this.stringValue(expression, value));
                context.append("}");
                break;
            }
            case TEXT: {
                context.append("(");
                context.append(this.stringValue(expression, value));
                context.append(")");
                break;
            }
            default: {
                throw new UnsupportedOperationException(MessageFormat.format("Field type {0} not supported", field.fieldType()));
            }
        }
    }

    private Object stringValue(Filter.Expression expression, Filter.Value value) {
        String delimiter = this.tagValueDelimiter(expression);
        Object object = value.value();
        if (object instanceof List) {
            List list = (List)object;
            return String.join((CharSequence)delimiter, list.stream().map(String::valueOf).toList());
        }
        return value.value();
    }

    private String tagValueDelimiter(Filter.Expression expression) {
        return switch (expression.type()) {
            case Filter.ExpressionType.IN -> " | ";
            case Filter.ExpressionType.EQ -> " ";
            default -> throw new UnsupportedOperationException(MessageFormat.format("Tag operand {0} not supported", expression.type()));
        };
    }

    private Numeric numeric(Filter.Expression expression, Filter.Value value) {
        return switch (expression.type()) {
            case Filter.ExpressionType.EQ -> new Numeric(this.inclusive(value), this.inclusive(value));
            case Filter.ExpressionType.GT -> new Numeric(this.exclusive(value), NumericBoundary.POSITIVE_INFINITY);
            case Filter.ExpressionType.GTE -> new Numeric(this.inclusive(value), NumericBoundary.POSITIVE_INFINITY);
            case Filter.ExpressionType.LT -> new Numeric(NumericBoundary.NEGATIVE_INFINITY, this.exclusive(value));
            case Filter.ExpressionType.LTE -> new Numeric(NumericBoundary.NEGATIVE_INFINITY, this.inclusive(value));
            default -> throw new UnsupportedOperationException(MessageFormat.format("Expression type {0} not supported for numeric fields", expression.type()));
        };
    }

    private NumericBoundary inclusive(Filter.Value value) {
        return new NumericBoundary(value.value(), false);
    }

    private NumericBoundary exclusive(Filter.Value value) {
        return new NumericBoundary(value.value(), true);
    }

    record Numeric(NumericBoundary lower, NumericBoundary upper) {
    }

    record NumericBoundary(Object value, boolean exclusive) {
        private static final NumericBoundary POSITIVE_INFINITY = new NumericBoundary(Double.POSITIVE_INFINITY, true);
        private static final NumericBoundary NEGATIVE_INFINITY = new NumericBoundary(Double.NEGATIVE_INFINITY, true);
        private static final String INFINITY = "inf";
        private static final String MINUS_INFINITY = "-inf";
        private static final String INCLUSIVE_FORMAT = "%s";
        private static final String EXCLUSIVE_FORMAT = "(%s";

        @Override
        public String toString() {
            if (this == NEGATIVE_INFINITY) {
                return MINUS_INFINITY;
            }
            if (this == POSITIVE_INFINITY) {
                return INFINITY;
            }
            return String.format(this.formatString(), this.value);
        }

        private String formatString() {
            if (this.exclusive) {
                return EXCLUSIVE_FORMAT;
            }
            return INCLUSIVE_FORMAT;
        }
    }
}

