/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader.pdf.layout;

import org.apache.pdfbox.text.TextPosition;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.reader.pdf.layout.Character;
import org.springframework.util.Assert;

class CharacterFactory {
    private @Nullable TextPosition previousTextPosition;
    private final boolean firstCharacterOfLineFound;
    private boolean isCharacterPartOfPreviousWord;
    private boolean isFirstCharacterOfAWord;
    private boolean isCharacterAtTheBeginningOfNewLine;
    private boolean isCharacterCloseToPreviousWord;

    CharacterFactory(boolean firstCharacterOfLineFound) {
        this.firstCharacterOfLineFound = firstCharacterOfLineFound;
    }

    public Character createCharacterFromTextPosition(TextPosition textPosition, @Nullable TextPosition previousTextPosition) {
        this.previousTextPosition = previousTextPosition;
        this.isCharacterPartOfPreviousWord = this.isCharacterPartOfPreviousWord(textPosition);
        this.isFirstCharacterOfAWord = this.isFirstCharacterOfAWord(textPosition);
        this.isCharacterAtTheBeginningOfNewLine = this.isCharacterAtTheBeginningOfNewLine(textPosition);
        this.isCharacterCloseToPreviousWord = this.isCharacterCloseToPreviousWord(textPosition);
        char character = this.getCharacterFromTextPosition(textPosition);
        int index = (int)textPosition.getX() / 4;
        return new Character(character, index, this.isCharacterPartOfPreviousWord, this.isFirstCharacterOfAWord, this.isCharacterAtTheBeginningOfNewLine, this.isCharacterCloseToPreviousWord);
    }

    private boolean isCharacterAtTheBeginningOfNewLine(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return true;
        }
        Assert.state((this.previousTextPosition != null ? 1 : 0) != 0, (String)"Text position should have been set");
        float previousTextYPosition = this.previousTextPosition.getY();
        return Math.round(textPosition.getY()) < Math.round(previousTextYPosition);
    }

    private boolean isFirstCharacterOfAWord(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return true;
        }
        Assert.state((this.previousTextPosition != null ? 1 : 0) != 0, (String)"Text position should have been set");
        double numberOfSpaces = this.numberOfSpacesBetweenTwoCharacters(this.previousTextPosition, textPosition);
        return numberOfSpaces > 1.0 || this.isCharacterAtTheBeginningOfNewLine(textPosition);
    }

    private boolean isCharacterCloseToPreviousWord(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return false;
        }
        Assert.state((this.previousTextPosition != null ? 1 : 0) != 0, (String)"Text position should have been set");
        double numberOfSpaces = this.numberOfSpacesBetweenTwoCharacters(this.previousTextPosition, textPosition);
        return numberOfSpaces > 1.0 && numberOfSpaces <= 4.0;
    }

    private boolean isCharacterPartOfPreviousWord(TextPosition textPosition) {
        Assert.state((this.previousTextPosition != null ? 1 : 0) != 0, (String)"Text position should have been set");
        if (this.previousTextPosition.getUnicode().equals(" ")) {
            return false;
        }
        double numberOfSpaces = this.numberOfSpacesBetweenTwoCharacters(this.previousTextPosition, textPosition);
        return numberOfSpaces <= 1.0;
    }

    private double numberOfSpacesBetweenTwoCharacters(TextPosition textPosition1, TextPosition textPosition2) {
        double previousTextXPosition = textPosition1.getX();
        double previousTextWidth = textPosition1.getWidth();
        double previousTextEndXPosition = previousTextXPosition + previousTextWidth;
        double numberOfSpaces = Math.abs(Math.round((double)textPosition2.getX() - previousTextEndXPosition));
        return numberOfSpaces;
    }

    private char getCharacterFromTextPosition(TextPosition textPosition) {
        String string = textPosition.getUnicode();
        char character = !string.isEmpty() ? string.charAt(0) : (char)'\u0000';
        return character;
    }
}

