/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader.pdf.layout;

import org.apache.pdfbox.text.TextPosition;
import org.springframework.ai.reader.pdf.layout.Character;

class CharacterFactory {
    private TextPosition previousTextPosition;
    private boolean firstCharacterOfLineFound;
    private boolean isCharacterPartOfPreviousWord;
    private boolean isFirstCharacterOfAWord;
    private boolean isCharacterAtTheBeginningOfNewLine;
    private boolean isCharacterCloseToPreviousWord;

    public CharacterFactory(boolean firstCharacterOfLineFound) {
        this.firstCharacterOfLineFound = firstCharacterOfLineFound;
    }

    public Character createCharacterFromTextPosition(TextPosition textPosition, TextPosition previousTextPosition) {
        this.setPreviousTextPosition(previousTextPosition);
        this.isCharacterPartOfPreviousWord = this.isCharacterPartOfPreviousWord(textPosition);
        this.isFirstCharacterOfAWord = this.isFirstCharacterOfAWord(textPosition);
        this.isCharacterAtTheBeginningOfNewLine = this.isCharacterAtTheBeginningOfNewLine(textPosition);
        this.isCharacterCloseToPreviousWord = this.isCharacterCloseToPreviousWord(textPosition);
        char character = this.getCharacterFromTextPosition(textPosition);
        int index = (int)textPosition.getX() / 4;
        return new Character(character, index, this.isCharacterPartOfPreviousWord, this.isFirstCharacterOfAWord, this.isCharacterAtTheBeginningOfNewLine, this.isCharacterCloseToPreviousWord);
    }

    private boolean isCharacterAtTheBeginningOfNewLine(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return true;
        }
        TextPosition previousTextPosition = this.getPreviousTextPosition();
        float previousTextYPosition = previousTextPosition.getY();
        return Math.round(textPosition.getY()) < Math.round(previousTextYPosition);
    }

    private boolean isFirstCharacterOfAWord(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return true;
        }
        double numberOfSpaces = this.numberOfSpacesBetweenTwoCharacters(this.previousTextPosition, textPosition);
        return numberOfSpaces > 1.0 || this.isCharacterAtTheBeginningOfNewLine(textPosition);
    }

    private boolean isCharacterCloseToPreviousWord(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return false;
        }
        double numberOfSpaces = this.numberOfSpacesBetweenTwoCharacters(this.previousTextPosition, textPosition);
        return numberOfSpaces > 1.0 && numberOfSpaces <= 4.0;
    }

    private boolean isCharacterPartOfPreviousWord(TextPosition textPosition) {
        TextPosition previousTextPosition = this.getPreviousTextPosition();
        if (previousTextPosition.getUnicode().equals(" ")) {
            return false;
        }
        double numberOfSpaces = this.numberOfSpacesBetweenTwoCharacters(previousTextPosition, textPosition);
        return numberOfSpaces <= 1.0;
    }

    private double numberOfSpacesBetweenTwoCharacters(TextPosition textPosition1, TextPosition textPosition2) {
        double previousTextXPosition = textPosition1.getX();
        double previousTextWidth = textPosition1.getWidth();
        double previousTextEndXPosition = previousTextXPosition + previousTextWidth;
        double numberOfSpaces = Math.abs(Math.round((double)textPosition2.getX() - previousTextEndXPosition));
        return numberOfSpaces;
    }

    private char getCharacterFromTextPosition(TextPosition textPosition) {
        String string = textPosition.getUnicode();
        char character = string.charAt(0);
        return character;
    }

    private TextPosition getPreviousTextPosition() {
        return this.previousTextPosition;
    }

    private void setPreviousTextPosition(TextPosition previousTextPosition) {
        this.previousTextPosition = previousTextPosition;
    }
}

