/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageGenerationMetadata;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.ai.image.observation.DefaultImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiImageOptions;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.ai.openai.api.common.OpenAiApiConstants;
import org.springframework.ai.openai.metadata.OpenAiImageGenerationMetadata;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;

public class OpenAiImageModel
implements ImageModel {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiImageModel.class);
    private static final ImageModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultImageModelObservationConvention();
    private final OpenAiImageOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiImageApi openAiImageApi;
    private final ObservationRegistry observationRegistry;
    private ImageModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OpenAiImageModel(OpenAiImageApi openAiImageApi) {
        this(openAiImageApi, OpenAiImageOptions.builder().build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiImageModel(OpenAiImageApi openAiImageApi, OpenAiImageOptions options, RetryTemplate retryTemplate) {
        this(openAiImageApi, options, retryTemplate, ObservationRegistry.NOOP);
    }

    public OpenAiImageModel(OpenAiImageApi openAiImageApi, OpenAiImageOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)openAiImageApi, (String)"OpenAiImageApi must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.openAiImageApi = openAiImageApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public ImageResponse call(ImagePrompt imagePrompt) {
        ImagePrompt requestImagePrompt = this.buildRequestImagePrompt(imagePrompt);
        OpenAiImageApi.OpenAiImageRequest imageRequest = this.createRequest(requestImagePrompt);
        ImageModelObservationContext observationContext = ImageModelObservationContext.builder().imagePrompt(imagePrompt).provider(OpenAiApiConstants.PROVIDER_NAME).build();
        return (ImageResponse)ImageModelObservationDocumentation.IMAGE_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity imageResponseEntity = (ResponseEntity)RetryUtils.execute((RetryTemplate)this.retryTemplate, () -> this.openAiImageApi.createImage(imageRequest));
            ImageResponse imageResponse = this.convertResponse((ResponseEntity<OpenAiImageApi.OpenAiImageResponse>)imageResponseEntity, imageRequest);
            observationContext.setResponse((Object)imageResponse);
            return imageResponse;
        });
    }

    private OpenAiImageApi.OpenAiImageRequest createRequest(ImagePrompt imagePrompt) {
        String instructions = ((ImageMessage)imagePrompt.getInstructions().get(0)).getText();
        OpenAiImageOptions imageOptions = (OpenAiImageOptions)imagePrompt.getOptions();
        OpenAiImageApi.OpenAiImageRequest imageRequest = new OpenAiImageApi.OpenAiImageRequest(instructions, OpenAiImageApi.DEFAULT_IMAGE_MODEL);
        return (OpenAiImageApi.OpenAiImageRequest)ModelOptionsUtils.merge((Object)imageOptions, (Object)imageRequest, OpenAiImageApi.OpenAiImageRequest.class);
    }

    private ImageResponse convertResponse(ResponseEntity<OpenAiImageApi.OpenAiImageResponse> imageResponseEntity, OpenAiImageApi.OpenAiImageRequest openAiImageRequest) {
        OpenAiImageApi.OpenAiImageResponse imageApiResponse = (OpenAiImageApi.OpenAiImageResponse)imageResponseEntity.getBody();
        if (imageApiResponse == null) {
            logger.warn("No image response returned for request: {}", (Object)openAiImageRequest);
            return new ImageResponse(List.of());
        }
        List<ImageGeneration> imageGenerationList = imageApiResponse.data().stream().map(entry -> new ImageGeneration(new Image(entry.url(), entry.b64Json()), (ImageGenerationMetadata)new OpenAiImageGenerationMetadata(entry.revisedPrompt()))).toList();
        ImageResponseMetadata openAiImageResponseMetadata = new ImageResponseMetadata(imageApiResponse.created());
        return new ImageResponse(imageGenerationList, openAiImageResponseMetadata);
    }

    private ImagePrompt buildRequestImagePrompt(ImagePrompt imagePrompt) {
        OpenAiImageOptions runtimeOptions = null;
        if (imagePrompt.getOptions() != null) {
            runtimeOptions = (OpenAiImageOptions)ModelOptionsUtils.copyToTarget((Object)imagePrompt.getOptions(), ImageOptions.class, OpenAiImageOptions.class);
        }
        OpenAiImageOptions requestOptions = runtimeOptions == null ? this.defaultOptions : OpenAiImageOptions.builder().model((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getModel(), (Object)this.defaultOptions.getModel())).N((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getN(), (Object)this.defaultOptions.getN())).responseFormat((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getResponseFormat(), (Object)this.defaultOptions.getResponseFormat())).width((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getWidth(), (Object)this.defaultOptions.getWidth())).height((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getHeight(), (Object)this.defaultOptions.getHeight())).style((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getStyle(), (Object)this.defaultOptions.getStyle())).quality((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getQuality(), (Object)this.defaultOptions.getQuality())).user((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getUser(), (Object)this.defaultOptions.getUser())).build();
        return new ImagePrompt(imagePrompt.getInstructions(), (ImageOptions)requestOptions);
    }

    public void setObservationConvention(ImageModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

