/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.audio.transcription.AudioTranscription;
import org.springframework.ai.audio.transcription.AudioTranscriptionOptions;
import org.springframework.ai.audio.transcription.AudioTranscriptionPrompt;
import org.springframework.ai.audio.transcription.AudioTranscriptionResponse;
import org.springframework.ai.audio.transcription.AudioTranscriptionResponseMetadata;
import org.springframework.ai.audio.transcription.TranscriptionModel;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.openai.OpenAiAudioTranscriptionOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.metadata.audio.OpenAiAudioTranscriptionResponseMetadata;
import org.springframework.ai.openai.metadata.support.OpenAiResponseHeaderExtractor;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;

public class OpenAiAudioTranscriptionModel
implements TranscriptionModel {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpenAiAudioTranscriptionOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiAudioApi audioApi;

    public OpenAiAudioTranscriptionModel(OpenAiAudioApi audioApi) {
        this(audioApi, OpenAiAudioTranscriptionOptions.builder().model(OpenAiAudioApi.TranscriptionModels.WHISPER_1.getValue()).responseFormat(OpenAiAudioApi.TranscriptResponseFormat.JSON).temperature(Float.valueOf(0.7f)).build());
    }

    public OpenAiAudioTranscriptionModel(OpenAiAudioApi audioApi, OpenAiAudioTranscriptionOptions options) {
        this(audioApi, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiAudioTranscriptionModel(OpenAiAudioApi audioApi, OpenAiAudioTranscriptionOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)audioApi, (String)"OpenAiAudioApi must not be null");
        Assert.notNull((Object)options, (String)"OpenAiTranscriptionOptions must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.audioApi = audioApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public String call(Resource audioResource) {
        AudioTranscriptionPrompt transcriptionRequest = new AudioTranscriptionPrompt(audioResource);
        return this.call(transcriptionRequest).getResult().getOutput();
    }

    public AudioTranscriptionResponse call(AudioTranscriptionPrompt transcriptionPrompt) {
        ResponseEntity transcriptionEntity;
        Resource audioResource = transcriptionPrompt.getInstructions();
        OpenAiAudioApi.TranscriptionRequest request = this.createRequest(transcriptionPrompt);
        if (request.responseFormat().isJsonType()) {
            ResponseEntity transcriptionEntity2;
            try {
                transcriptionEntity2 = (ResponseEntity)this.retryTemplate.execute(() -> this.audioApi.createTranscription(request, OpenAiAudioApi.StructuredResponse.class));
            }
            catch (Exception e) {
                throw new RuntimeException("Error calling OpenAI transcription API", e);
            }
            OpenAiAudioApi.StructuredResponse transcription = (OpenAiAudioApi.StructuredResponse)transcriptionEntity2.getBody();
            if (transcription == null) {
                this.logger.warn("No transcription returned for request: {}", (Object)audioResource);
                return new AudioTranscriptionResponse(null);
            }
            AudioTranscription transcript = new AudioTranscription(transcription.text());
            RateLimit rateLimits = OpenAiResponseHeaderExtractor.extractAiResponseHeaders(transcriptionEntity2);
            return new AudioTranscriptionResponse(transcript, (AudioTranscriptionResponseMetadata)OpenAiAudioTranscriptionResponseMetadata.from((OpenAiAudioApi.StructuredResponse)transcriptionEntity2.getBody()).withRateLimit(rateLimits));
        }
        try {
            transcriptionEntity = (ResponseEntity)this.retryTemplate.execute(() -> this.audioApi.createTranscription(request, String.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling OpenAI transcription API", e);
        }
        String transcription = (String)transcriptionEntity.getBody();
        if (transcription == null) {
            this.logger.warn("No transcription returned for request: {}", (Object)audioResource);
            return new AudioTranscriptionResponse(null);
        }
        AudioTranscription transcript = new AudioTranscription(transcription);
        RateLimit rateLimits = OpenAiResponseHeaderExtractor.extractAiResponseHeaders(transcriptionEntity);
        return new AudioTranscriptionResponse(transcript, (AudioTranscriptionResponseMetadata)OpenAiAudioTranscriptionResponseMetadata.from((String)transcriptionEntity.getBody()).withRateLimit(rateLimits));
    }

    OpenAiAudioApi.TranscriptionRequest createRequest(AudioTranscriptionPrompt transcriptionPrompt) {
        OpenAiAudioTranscriptionOptions options = this.defaultOptions;
        if (transcriptionPrompt.getOptions() != null) {
            AudioTranscriptionOptions audioTranscriptionOptions = transcriptionPrompt.getOptions();
            if (audioTranscriptionOptions instanceof OpenAiAudioTranscriptionOptions) {
                OpenAiAudioTranscriptionOptions runtimeOptions = (OpenAiAudioTranscriptionOptions)audioTranscriptionOptions;
                options = this.merge(runtimeOptions, options);
            } else {
                throw new IllegalArgumentException("Prompt options are not of type TranscriptionOptions: " + transcriptionPrompt.getOptions().getClass().getSimpleName());
            }
        }
        Resource instructions = transcriptionPrompt.getInstructions();
        return OpenAiAudioApi.TranscriptionRequest.builder().file(this.toBytes(instructions)).fileName(instructions.getFilename()).responseFormat(options.getResponseFormat()).prompt(options.getPrompt()).temperature(options.getTemperature()).language(options.getLanguage()).model(options.getModel()).granularityType(options.getGranularityType()).build();
    }

    private byte[] toBytes(Resource resource) {
        try {
            return resource.getInputStream().readAllBytes();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read resource: " + String.valueOf(resource), e);
        }
    }

    private OpenAiAudioTranscriptionOptions merge(OpenAiAudioTranscriptionOptions source, OpenAiAudioTranscriptionOptions target) {
        if (source == null) {
            source = new OpenAiAudioTranscriptionOptions();
        }
        OpenAiAudioTranscriptionOptions merged = new OpenAiAudioTranscriptionOptions();
        merged.setLanguage(source.getLanguage() != null ? source.getLanguage() : target.getLanguage());
        merged.setModel(source.getModel() != null ? source.getModel() : target.getModel());
        merged.setPrompt(source.getPrompt() != null ? source.getPrompt() : target.getPrompt());
        merged.setResponseFormat(source.getResponseFormat() != null ? source.getResponseFormat() : target.getResponseFormat());
        merged.setTemperature(source.getTemperature() != null ? source.getTemperature() : target.getTemperature());
        merged.setGranularityType(source.getGranularityType() != null ? source.getGranularityType() : target.getGranularityType());
        return merged;
    }
}

