/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openaisdk;

import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.credential.Credential;
import com.openai.models.embeddings.EmbeddingCreateParams;
import com.openai.models.embeddings.EmbeddingModel;
import java.net.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.openaisdk.AbstractOpenAiSdkOptions;

public class OpenAiSdkEmbeddingOptions
extends AbstractOpenAiSdkOptions
implements EmbeddingOptions {
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingModel.TEXT_EMBEDDING_ADA_002.asString();
    private String user;
    private Integer dimensions;

    public static Builder builder() {
        return new Builder();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public String toString() {
        return "OpenAiSdkEmbeddingOptions{user='" + this.user + "', model='" + this.getModel() + "', deploymentName='" + this.getDeploymentName() + "', dimensions=" + this.dimensions + "}";
    }

    public EmbeddingCreateParams toOpenAiCreateParams(List<String> instructions) {
        EmbeddingCreateParams.Builder builder = EmbeddingCreateParams.builder();
        if (this.getDeploymentName() != null) {
            builder.model(this.getDeploymentName());
        } else if (this.getModel() != null) {
            builder.model(this.getModel());
        }
        if (instructions != null && !instructions.isEmpty()) {
            builder.input(EmbeddingCreateParams.Input.ofArrayOfStrings(instructions));
        }
        if (this.getUser() != null) {
            builder.user(this.getUser());
        }
        if (this.getDimensions() != null) {
            builder.dimensions((long)this.getDimensions().intValue());
        }
        return builder.build();
    }

    public static final class Builder {
        private final OpenAiSdkEmbeddingOptions options = new OpenAiSdkEmbeddingOptions();

        public Builder from(OpenAiSdkEmbeddingOptions fromOptions) {
            this.options.setBaseUrl(fromOptions.getBaseUrl());
            this.options.setApiKey(fromOptions.getApiKey());
            this.options.setCredential(fromOptions.getCredential());
            this.options.setModel(fromOptions.getModel());
            this.options.setDeploymentName(fromOptions.getDeploymentName());
            this.options.setMicrosoftFoundryServiceVersion(fromOptions.getMicrosoftFoundryServiceVersion());
            this.options.setOrganizationId(fromOptions.getOrganizationId());
            this.options.setMicrosoftFoundry(fromOptions.isMicrosoftFoundry());
            this.options.setGitHubModels(fromOptions.isGitHubModels());
            this.options.setTimeout(fromOptions.getTimeout());
            this.options.setMaxRetries(fromOptions.getMaxRetries());
            this.options.setProxy(fromOptions.getProxy());
            this.options.setCustomHeaders(fromOptions.getCustomHeaders());
            this.options.setUser(fromOptions.getUser());
            this.options.setDimensions(fromOptions.getDimensions());
            return this;
        }

        public Builder merge(EmbeddingOptions from) {
            if (from instanceof OpenAiSdkEmbeddingOptions) {
                OpenAiSdkEmbeddingOptions castFrom = (OpenAiSdkEmbeddingOptions)from;
                if (castFrom.getBaseUrl() != null) {
                    this.options.setBaseUrl(castFrom.getBaseUrl());
                }
                if (castFrom.getApiKey() != null) {
                    this.options.setApiKey(castFrom.getApiKey());
                }
                if (castFrom.getCredential() != null) {
                    this.options.setCredential(castFrom.getCredential());
                }
                if (castFrom.getModel() != null) {
                    this.options.setModel(castFrom.getModel());
                }
                if (castFrom.getDeploymentName() != null) {
                    this.options.setDeploymentName(castFrom.getDeploymentName());
                }
                if (castFrom.getMicrosoftFoundryServiceVersion() != null) {
                    this.options.setMicrosoftFoundryServiceVersion(castFrom.getMicrosoftFoundryServiceVersion());
                }
                if (castFrom.getOrganizationId() != null) {
                    this.options.setOrganizationId(castFrom.getOrganizationId());
                }
                this.options.setMicrosoftFoundry(castFrom.isMicrosoftFoundry());
                this.options.setGitHubModels(castFrom.isGitHubModels());
                if (castFrom.getTimeout() != null) {
                    this.options.setTimeout(castFrom.getTimeout());
                }
                if (castFrom.getMaxRetries() != null) {
                    this.options.setMaxRetries(castFrom.getMaxRetries());
                }
                if (castFrom.getProxy() != null) {
                    this.options.setProxy(castFrom.getProxy());
                }
                if (castFrom.getCustomHeaders() != null) {
                    this.options.setCustomHeaders(castFrom.getCustomHeaders());
                }
                if (castFrom.getUser() != null) {
                    this.options.setUser(castFrom.getUser());
                }
                if (castFrom.getDimensions() != null) {
                    this.options.setDimensions(castFrom.getDimensions());
                }
            }
            return this;
        }

        public Builder from(EmbeddingCreateParams openAiCreateParams) {
            if (openAiCreateParams.user().isPresent()) {
                this.options.setUser((String)openAiCreateParams.user().get());
            }
            if (openAiCreateParams.dimensions().isPresent()) {
                this.options.setDimensions(Math.toIntExact((Long)openAiCreateParams.dimensions().get()));
            }
            return this;
        }

        public Builder user(String user) {
            this.options.setUser(user);
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.options.setDeploymentName(deploymentName);
            return this;
        }

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.options.setBaseUrl(baseUrl);
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.options.setApiKey(apiKey);
            return this;
        }

        public Builder credential(Credential credential) {
            this.options.setCredential(credential);
            return this;
        }

        public Builder azureOpenAIServiceVersion(AzureOpenAIServiceVersion azureOpenAIServiceVersion) {
            this.options.setMicrosoftFoundryServiceVersion(azureOpenAIServiceVersion);
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.options.setOrganizationId(organizationId);
            return this;
        }

        public Builder azure(boolean azure) {
            this.options.setMicrosoftFoundry(azure);
            return this;
        }

        public Builder gitHubModels(boolean gitHubModels) {
            this.options.setGitHubModels(gitHubModels);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.options.setTimeout(timeout);
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.options.setMaxRetries(maxRetries);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.options.setProxy(proxy);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.options.setCustomHeaders(customHeaders);
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            this.options.dimensions = dimensions;
            return this;
        }

        public OpenAiSdkEmbeddingOptions build() {
            return this.options;
        }
    }
}

