/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openaisdk;

import com.openai.client.OpenAIClient;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import com.openai.models.embeddings.EmbeddingCreateParams;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.EmbeddingUtils;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.openaisdk.OpenAiSdkEmbeddingOptions;
import org.springframework.ai.openaisdk.setup.OpenAiSdkSetup;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class OpenAiSdkEmbeddingModel
extends AbstractEmbeddingModel {
    private static final String DEFAULT_MODEL_NAME = OpenAiSdkEmbeddingOptions.DEFAULT_EMBEDDING_MODEL;
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private static final Logger logger = LoggerFactory.getLogger(OpenAiSdkEmbeddingModel.class);
    private final OpenAIClient openAiClient;
    private final OpenAiSdkEmbeddingOptions options;
    private final MetadataMode metadataMode;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OpenAiSdkEmbeddingModel() {
        this(null, null, null, null);
    }

    public OpenAiSdkEmbeddingModel(OpenAiSdkEmbeddingOptions options) {
        this(null, null, options, null);
    }

    public OpenAiSdkEmbeddingModel(MetadataMode metadataMode, OpenAiSdkEmbeddingOptions options) {
        this(null, metadataMode, options, null);
    }

    public OpenAiSdkEmbeddingModel(OpenAiSdkEmbeddingOptions options, ObservationRegistry observationRegistry) {
        this(null, null, options, observationRegistry);
    }

    public OpenAiSdkEmbeddingModel(MetadataMode metadataMode, OpenAiSdkEmbeddingOptions options, ObservationRegistry observationRegistry) {
        this(null, metadataMode, options, observationRegistry);
    }

    public OpenAiSdkEmbeddingModel(OpenAIClient openAiClient) {
        this(openAiClient, null, null, null);
    }

    public OpenAiSdkEmbeddingModel(OpenAIClient openAiClient, MetadataMode metadataMode) {
        this(openAiClient, metadataMode, null, null);
    }

    public OpenAiSdkEmbeddingModel(OpenAIClient openAiClient, MetadataMode metadataMode, OpenAiSdkEmbeddingOptions options) {
        this(openAiClient, metadataMode, options, null);
    }

    public OpenAiSdkEmbeddingModel(OpenAIClient openAiClient, MetadataMode metadataMode, OpenAiSdkEmbeddingOptions options, ObservationRegistry observationRegistry) {
        this.options = options == null ? OpenAiSdkEmbeddingOptions.builder().model(DEFAULT_MODEL_NAME).build() : options;
        this.openAiClient = Objects.requireNonNullElseGet(openAiClient, () -> OpenAiSdkSetup.setupSyncClient(this.options.getBaseUrl(), this.options.getApiKey(), this.options.getCredential(), this.options.getMicrosoftDeploymentName(), this.options.getMicrosoftFoundryServiceVersion(), this.options.getOrganizationId(), this.options.isMicrosoftFoundry(), this.options.isGitHubModels(), this.options.getModel(), this.options.getTimeout(), this.options.getMaxRetries(), this.options.getProxy(), this.options.getCustomHeaders()));
        this.metadataMode = Objects.requireNonNullElse(metadataMode, MetadataMode.EMBED);
        this.observationRegistry = Objects.requireNonNullElse(observationRegistry, ObservationRegistry.NOOP);
    }

    public float[] embed(Document document) {
        EmbeddingResponse response = this.call(new EmbeddingRequest(List.of(document.getFormattedContent(this.metadataMode)), null));
        if (CollectionUtils.isEmpty((Collection)response.getResults())) {
            return new float[0];
        }
        return ((Embedding)response.getResults().get(0)).getOutput();
    }

    public EmbeddingResponse call(EmbeddingRequest embeddingRequest) {
        OpenAiSdkEmbeddingOptions options = OpenAiSdkEmbeddingOptions.builder().from(this.options).merge(embeddingRequest.getOptions()).build();
        EmbeddingRequest embeddingRequestWithMergedOptions = new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)options);
        EmbeddingCreateParams embeddingCreateParams = options.toOpenAiCreateParams(embeddingRequestWithMergedOptions.getInstructions());
        if (logger.isTraceEnabled()) {
            logger.trace("OpenAiSdkEmbeddingModel call {} with the following options : {} ", (Object)options.getModel(), (Object)embeddingCreateParams);
        }
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(embeddingRequestWithMergedOptions).provider(AiProvider.OPENAI_SDK.value()).build();
        return Objects.requireNonNull((EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            CreateEmbeddingResponse response = this.openAiClient.embeddings().create(embeddingCreateParams);
            EmbeddingResponse embeddingResponse = this.generateEmbeddingResponse(response);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        }));
    }

    private EmbeddingResponse generateEmbeddingResponse(CreateEmbeddingResponse response) {
        List<Embedding> data = this.generateEmbeddingList(response.data());
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.setModel(response.model());
        metadata.setUsage((Usage)this.getDefaultUsage(response.usage()));
        return new EmbeddingResponse(data, metadata);
    }

    private DefaultUsage getDefaultUsage(CreateEmbeddingResponse.Usage nativeUsage) {
        return new DefaultUsage(Integer.valueOf(Math.toIntExact(nativeUsage.promptTokens())), Integer.valueOf(0), Integer.valueOf(Math.toIntExact(nativeUsage.totalTokens())), (Object)nativeUsage);
    }

    private List<Embedding> generateEmbeddingList(List<com.openai.models.embeddings.Embedding> nativeData) {
        ArrayList<Embedding> data = new ArrayList<Embedding>();
        for (com.openai.models.embeddings.Embedding nativeDatum : nativeData) {
            List nativeDatumEmbedding = nativeDatum.embedding();
            long nativeIndex = nativeDatum.index();
            Embedding embedding = new Embedding(EmbeddingUtils.toPrimitive((List)nativeDatumEmbedding), Integer.valueOf(Math.toIntExact(nativeIndex)));
            data.add(embedding);
        }
        return data;
    }

    public OpenAiSdkEmbeddingOptions getOptions() {
        return this.options;
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

