/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openaisdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.credential.Credential;
import com.openai.models.ChatModel;
import com.openai.models.chat.completions.ChatCompletionAudioParam;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.model.tool.StructuredOutputChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.openaisdk.AbstractOpenAiSdkOptions;
import org.springframework.ai.openaisdk.OpenAiSdkChatModel;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenAiSdkChatOptions
extends AbstractOpenAiSdkOptions
implements ToolCallingChatOptions,
StructuredOutputChatOptions {
    public static final String DEFAULT_CHAT_MODEL = ChatModel.GPT_5_MINI.asString();
    private static final Logger logger = LoggerFactory.getLogger(OpenAiSdkChatOptions.class);
    private Double frequencyPenalty;
    private Map<String, Integer> logitBias;
    private Boolean logprobs;
    private Integer topLogprobs;
    private Integer maxTokens;
    private Integer maxCompletionTokens;
    private Integer n;
    private List<String> outputModalities;
    private AudioParameters outputAudio;
    private Double presencePenalty;
    private OpenAiSdkChatModel.ResponseFormat responseFormat;
    private StreamOptions streamOptions;
    private Integer seed;
    private List<String> stop;
    private Double temperature;
    private Double topP;
    private Object toolChoice;
    private String user;
    private Boolean parallelToolCalls;
    private Boolean store;
    private Map<String, String> metadata;
    private String reasoningEffort;
    private String verbosity;
    private String serviceTier;
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    private Set<String> toolNames = new HashSet<String>();
    private Boolean internalToolExecutionEnabled;
    private Map<String, Object> toolContext = new HashMap<String, Object>();

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public void setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public List<String> getOutputModalities() {
        return this.outputModalities;
    }

    public void setOutputModalities(List<String> outputModalities) {
        this.outputModalities = outputModalities;
    }

    public AudioParameters getOutputAudio() {
        return this.outputAudio;
    }

    public void setOutputAudio(AudioParameters outputAudio) {
        this.outputAudio = outputAudio;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public OpenAiSdkChatModel.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(OpenAiSdkChatModel.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(StreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public List<String> getStopSequences() {
        return this.getStop();
    }

    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(Object toolChoice) {
        this.toolChoice = toolChoice;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public void setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
    }

    public Boolean getStore() {
        return this.store;
    }

    public void setStore(Boolean store) {
        this.store = store;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getReasoningEffort() {
        return this.reasoningEffort;
    }

    public void setReasoningEffort(String reasoningEffort) {
        this.reasoningEffort = reasoningEffort;
    }

    public String getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(String verbosity) {
        this.verbosity = verbosity;
    }

    public String getServiceTier() {
        return this.serviceTier;
    }

    public void setServiceTier(String serviceTier) {
        this.serviceTier = serviceTier;
    }

    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    public Set<String> getToolNames() {
        return this.toolNames;
    }

    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Integer getTopK() {
        return null;
    }

    @JsonIgnore
    public String getOutputSchema() {
        return this.getResponseFormat().getJsonSchema();
    }

    @JsonIgnore
    public void setOutputSchema(String outputSchema) {
        this.setResponseFormat(OpenAiSdkChatModel.ResponseFormat.builder().type(OpenAiSdkChatModel.ResponseFormat.Type.JSON_SCHEMA).jsonSchema(outputSchema).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public OpenAiSdkChatOptions copy() {
        return OpenAiSdkChatOptions.builder().from(this).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiSdkChatOptions options = (OpenAiSdkChatOptions)o;
        return Objects.equals(this.getModel(), options.getModel()) && Objects.equals(this.frequencyPenalty, options.frequencyPenalty) && Objects.equals(this.logitBias, options.logitBias) && Objects.equals(this.logprobs, options.logprobs) && Objects.equals(this.temperature, options.temperature) && Objects.equals(this.maxTokens, options.maxTokens) && Objects.equals(this.maxCompletionTokens, options.maxCompletionTokens) && Objects.equals(this.n, options.n) && Objects.equals(this.outputModalities, options.outputModalities) && Objects.equals(this.outputAudio, options.outputAudio) && Objects.equals(this.presencePenalty, options.presencePenalty) && Objects.equals(this.responseFormat, options.responseFormat) && Objects.equals(this.streamOptions, options.streamOptions) && Objects.equals(this.seed, options.seed) && Objects.equals(this.stop, options.stop) && Objects.equals(this.temperature, options.temperature) && Objects.equals(this.topP, options.topP) && Objects.equals(this.toolChoice, options.toolChoice) && Objects.equals(this.user, options.user) && Objects.equals(this.parallelToolCalls, options.parallelToolCalls) && Objects.equals(this.store, options.store) && Objects.equals(this.metadata, options.metadata) && Objects.equals(this.reasoningEffort, options.reasoningEffort) && Objects.equals(this.verbosity, options.verbosity) && Objects.equals(this.serviceTier, options.serviceTier) && Objects.equals(this.toolCallbacks, options.toolCallbacks) && Objects.equals(this.toolNames, options.toolNames) && Objects.equals(this.internalToolExecutionEnabled, options.internalToolExecutionEnabled) && Objects.equals(this.toolContext, options.toolContext);
    }

    public int hashCode() {
        return Objects.hash(this.getModel(), this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, this.outputModalities, this.outputAudio, this.presencePenalty, this.responseFormat, this.streamOptions, this.seed, this.stop, this.temperature, this.topP, this.toolChoice, this.user, this.parallelToolCalls, this.store, this.metadata, this.reasoningEffort, this.verbosity, this.serviceTier, this.toolCallbacks, this.toolNames, this.internalToolExecutionEnabled, this.toolContext);
    }

    public String toString() {
        return "OpenAiSdkChatOptions{model='" + this.getModel() + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + String.valueOf(this.logitBias) + ", logprobs=" + this.logprobs + ", topLogprobs=" + this.topLogprobs + ", maxTokens=" + this.maxTokens + ", maxCompletionTokens=" + this.maxCompletionTokens + ", n=" + this.n + ", outputModalities=" + String.valueOf(this.outputModalities) + ", outputAudio=" + String.valueOf(this.outputAudio) + ", presencePenalty=" + this.presencePenalty + ", responseFormat=" + String.valueOf(this.responseFormat) + ", streamOptions=" + String.valueOf(this.streamOptions) + ", streamUsage=, seed=" + this.seed + ", stop=" + String.valueOf(this.stop) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", toolChoice=" + String.valueOf(this.toolChoice) + ", user='" + this.user + "', parallelToolCalls=" + this.parallelToolCalls + ", store=" + this.store + ", metadata=" + String.valueOf(this.metadata) + ", reasoningEffort='" + this.reasoningEffort + "', verbosity='" + this.verbosity + "', serviceTier='" + this.serviceTier + "', toolCallbacks=" + String.valueOf(this.toolCallbacks) + ", toolNames=" + String.valueOf(this.toolNames) + ", internalToolExecutionEnabled=" + this.internalToolExecutionEnabled + ", toolContext=" + String.valueOf(this.toolContext) + "}";
    }

    public record AudioParameters(Voice voice, AudioResponseFormat format) {
        public ChatCompletionAudioParam toChatCompletionAudioParam() {
            ChatCompletionAudioParam.Builder builder = ChatCompletionAudioParam.builder();
            if (this.voice() != null) {
                builder.voice(this.voice().name().toLowerCase());
            }
            if (this.format() != null) {
                builder.format(ChatCompletionAudioParam.Format.of((String)this.format().name().toLowerCase()));
            }
            return builder.build();
        }

        public static enum Voice {
            ALLOY,
            ASH,
            BALLAD,
            CORAL,
            ECHO,
            FABLE,
            ONYX,
            NOVA,
            SAGE,
            SHIMMER;

        }

        public static enum AudioResponseFormat {
            MP3,
            FLAC,
            OPUS,
            PCM16,
            WAV,
            AAC;

        }
    }

    public record StreamOptions(Boolean includeObfuscation, Boolean includeUsage, Map<String, Object> additionalProperties) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Boolean includeObfuscation;
            private Boolean includeUsage;
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            public Builder from(StreamOptions fromOptions) {
                if (fromOptions != null) {
                    this.includeObfuscation = fromOptions.includeObfuscation();
                    this.includeUsage = fromOptions.includeUsage();
                    this.additionalProperties = fromOptions.additionalProperties() != null ? new HashMap<String, Object>(fromOptions.additionalProperties()) : new HashMap();
                }
                return this;
            }

            public Builder includeObfuscation(Boolean includeObfuscation) {
                this.includeObfuscation = includeObfuscation;
                return this;
            }

            public Builder includeUsage(Boolean includeUsage) {
                this.includeUsage = includeUsage;
                return this;
            }

            public Builder additionalProperties(Map<String, Object> additionalProperties) {
                this.additionalProperties = additionalProperties != null ? new HashMap<String, Object>(additionalProperties) : new HashMap();
                return this;
            }

            public Builder additionalProperty(String key, Object value) {
                if (this.additionalProperties == null) {
                    this.additionalProperties = new HashMap<String, Object>();
                }
                this.additionalProperties.put(key, value);
                return this;
            }

            public StreamOptions build() {
                return new StreamOptions(this.includeObfuscation, this.includeUsage, this.additionalProperties);
            }
        }
    }

    public static final class Builder {
        private final OpenAiSdkChatOptions options = new OpenAiSdkChatOptions();

        public Builder from(OpenAiSdkChatOptions fromOptions) {
            this.options.setBaseUrl(fromOptions.getBaseUrl());
            this.options.setApiKey(fromOptions.getApiKey());
            this.options.setCredential(fromOptions.getCredential());
            this.options.setModel(fromOptions.getModel());
            this.options.setDeploymentName(fromOptions.getDeploymentName());
            this.options.setMicrosoftFoundryServiceVersion(fromOptions.getMicrosoftFoundryServiceVersion());
            this.options.setOrganizationId(fromOptions.getOrganizationId());
            this.options.setMicrosoftFoundry(fromOptions.isMicrosoftFoundry());
            this.options.setGitHubModels(fromOptions.isGitHubModels());
            this.options.setTimeout(fromOptions.getTimeout());
            this.options.setMaxRetries(fromOptions.getMaxRetries());
            this.options.setProxy(fromOptions.getProxy());
            this.options.setCustomHeaders((Map<String, String>)(fromOptions.getCustomHeaders() != null ? new HashMap<String, String>(fromOptions.getCustomHeaders()) : null));
            this.options.setFrequencyPenalty(fromOptions.getFrequencyPenalty());
            this.options.setLogitBias(fromOptions.getLogitBias());
            this.options.setLogprobs(fromOptions.getLogprobs());
            this.options.setTopLogprobs(fromOptions.getTopLogprobs());
            this.options.setMaxTokens(fromOptions.getMaxTokens());
            this.options.setMaxCompletionTokens(fromOptions.getMaxCompletionTokens());
            this.options.setN(fromOptions.getN());
            this.options.setOutputModalities(fromOptions.getOutputModalities());
            this.options.setOutputAudio(fromOptions.getOutputAudio());
            this.options.setPresencePenalty(fromOptions.getPresencePenalty());
            this.options.setResponseFormat(fromOptions.getResponseFormat());
            this.options.setStreamOptions(fromOptions.getStreamOptions());
            this.options.setSeed(fromOptions.getSeed());
            this.options.setStop((List<String>)(fromOptions.getStop() != null ? new ArrayList<String>(fromOptions.getStop()) : null));
            this.options.setTemperature(fromOptions.getTemperature());
            this.options.setTopP(fromOptions.getTopP());
            this.options.setToolChoice(fromOptions.getToolChoice());
            this.options.setUser(fromOptions.getUser());
            this.options.setParallelToolCalls(fromOptions.getParallelToolCalls());
            this.options.setToolCallbacks(new ArrayList<ToolCallback>(fromOptions.getToolCallbacks()));
            this.options.setToolNames(new HashSet<String>(fromOptions.getToolNames()));
            this.options.setInternalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled());
            this.options.setToolContext(new HashMap<String, Object>(fromOptions.getToolContext()));
            this.options.setStore(fromOptions.getStore());
            this.options.setMetadata(fromOptions.getMetadata());
            this.options.setReasoningEffort(fromOptions.getReasoningEffort());
            this.options.setVerbosity(fromOptions.getVerbosity());
            this.options.setServiceTier(fromOptions.getServiceTier());
            return this;
        }

        public Builder merge(OpenAiSdkChatOptions from) {
            if (from.getBaseUrl() != null) {
                this.options.setBaseUrl(from.getBaseUrl());
            }
            if (from.getApiKey() != null) {
                this.options.setApiKey(from.getApiKey());
            }
            if (from.getCredential() != null) {
                this.options.setCredential(from.getCredential());
            }
            if (from.getModel() != null) {
                this.options.setModel(from.getModel());
            }
            if (from.getDeploymentName() != null) {
                this.options.setDeploymentName(from.getDeploymentName());
            }
            if (from.getMicrosoftFoundryServiceVersion() != null) {
                this.options.setMicrosoftFoundryServiceVersion(from.getMicrosoftFoundryServiceVersion());
            }
            if (from.getOrganizationId() != null) {
                this.options.setOrganizationId(from.getOrganizationId());
            }
            this.options.setMicrosoftFoundry(from.isMicrosoftFoundry());
            this.options.setGitHubModels(from.isGitHubModels());
            if (from.getTimeout() != null) {
                this.options.setTimeout(from.getTimeout());
            }
            if (from.getMaxRetries() != null) {
                this.options.setMaxRetries(from.getMaxRetries());
            }
            if (from.getProxy() != null) {
                this.options.setProxy(from.getProxy());
            }
            if (from.getCustomHeaders() != null) {
                this.options.setCustomHeaders(from.getCustomHeaders());
            }
            if (from.getFrequencyPenalty() != null) {
                this.options.setFrequencyPenalty(from.getFrequencyPenalty());
            }
            if (from.getLogitBias() != null) {
                this.options.setLogitBias(from.getLogitBias());
            }
            if (from.getLogprobs() != null) {
                this.options.setLogprobs(from.getLogprobs());
            }
            if (from.getTopLogprobs() != null) {
                this.options.setTopLogprobs(from.getTopLogprobs());
            }
            if (from.getMaxTokens() != null) {
                this.options.setMaxTokens(from.getMaxTokens());
            }
            if (from.getMaxCompletionTokens() != null) {
                this.options.setMaxCompletionTokens(from.getMaxCompletionTokens());
            }
            if (from.getN() != null) {
                this.options.setN(from.getN());
            }
            if (from.getOutputModalities() != null) {
                this.options.setOutputModalities(new ArrayList<String>(from.getOutputModalities()));
            }
            if (from.getOutputAudio() != null) {
                this.options.setOutputAudio(from.getOutputAudio());
            }
            if (from.getPresencePenalty() != null) {
                this.options.setPresencePenalty(from.getPresencePenalty());
            }
            if (from.getResponseFormat() != null) {
                this.options.setResponseFormat(from.getResponseFormat());
            }
            if (from.getStreamOptions() != null) {
                this.options.setStreamOptions(from.getStreamOptions());
            }
            if (from.getSeed() != null) {
                this.options.setSeed(from.getSeed());
            }
            if (from.getStop() != null) {
                this.options.setStop(new ArrayList<String>(from.getStop()));
            }
            if (from.getTemperature() != null) {
                this.options.setTemperature(from.getTemperature());
            }
            if (from.getTopP() != null) {
                this.options.setTopP(from.getTopP());
            }
            if (from.getToolChoice() != null) {
                this.options.setToolChoice(from.getToolChoice());
            }
            if (from.getUser() != null) {
                this.options.setUser(from.getUser());
            }
            if (from.getParallelToolCalls() != null) {
                this.options.setParallelToolCalls(from.getParallelToolCalls());
            }
            if (!from.getToolCallbacks().isEmpty()) {
                this.options.setToolCallbacks(new ArrayList<ToolCallback>(from.getToolCallbacks()));
            }
            if (!from.getToolNames().isEmpty()) {
                this.options.setToolNames(new HashSet<String>(from.getToolNames()));
            }
            if (from.getInternalToolExecutionEnabled() != null) {
                this.options.setInternalToolExecutionEnabled(from.getInternalToolExecutionEnabled());
            }
            if (!from.getToolContext().isEmpty()) {
                this.options.setToolContext(new HashMap<String, Object>(from.getToolContext()));
            }
            if (from.getStore() != null) {
                this.options.setStore(from.getStore());
            }
            if (from.getMetadata() != null) {
                this.options.setMetadata(from.getMetadata());
            }
            if (from.getReasoningEffort() != null) {
                this.options.setReasoningEffort(from.getReasoningEffort());
            }
            if (from.getVerbosity() != null) {
                this.options.setVerbosity(from.getVerbosity());
            }
            if (from.getServiceTier() != null) {
                this.options.setServiceTier(from.getServiceTier());
            }
            return this;
        }

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.options.setDeploymentName(deploymentName);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.options.setBaseUrl(baseUrl);
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.options.setApiKey(apiKey);
            return this;
        }

        public Builder credential(Credential credential) {
            this.options.setCredential(credential);
            return this;
        }

        public Builder azureOpenAIServiceVersion(AzureOpenAIServiceVersion azureOpenAIServiceVersion) {
            this.options.setMicrosoftFoundryServiceVersion(azureOpenAIServiceVersion);
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.options.setOrganizationId(organizationId);
            return this;
        }

        public Builder azure(boolean azure) {
            this.options.setMicrosoftFoundry(azure);
            return this;
        }

        public Builder gitHubModels(boolean gitHubModels) {
            this.options.setGitHubModels(gitHubModels);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.options.setTimeout(timeout);
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.options.setMaxRetries(maxRetries);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.options.setProxy(proxy);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.options.setCustomHeaders(customHeaders);
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.setFrequencyPenalty(frequencyPenalty);
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.options.setLogitBias(logitBias);
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.options.setLogprobs(logprobs);
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.options.setTopLogprobs(topLogprobs);
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            if (maxTokens != null && this.options.getMaxCompletionTokens() != null) {
                logger.warn("Both maxTokens and maxCompletionTokens are set. OpenAI API does not support setting both parameters simultaneously. As maxToken is deprecated, we will ignore it and use maxCompletionToken ({}).", (Object)this.options.getMaxCompletionTokens());
            } else {
                this.options.setMaxTokens(maxTokens);
            }
            return this;
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            if (maxCompletionTokens != null && this.options.getMaxTokens() != null) {
                logger.warn("Both maxTokens and maxCompletionTokens are set. OpenAI API does not support setting both parameters simultaneously. As maxToken is deprecated, we will use maxCompletionToken ({}).", (Object)maxCompletionTokens);
                this.options.setMaxTokens(null);
            }
            this.options.setMaxCompletionTokens(maxCompletionTokens);
            return this;
        }

        public Builder N(Integer n) {
            this.options.setN(n);
            return this;
        }

        public Builder outputModalities(List<String> outputModalities) {
            this.options.setOutputModalities(outputModalities);
            return this;
        }

        public Builder outputAudio(AudioParameters audio) {
            this.options.setOutputAudio(audio);
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.setPresencePenalty(presencePenalty);
            return this;
        }

        public Builder responseFormat(OpenAiSdkChatModel.ResponseFormat responseFormat) {
            this.options.setResponseFormat(responseFormat);
            return this;
        }

        public Builder streamOptions(StreamOptions streamOptions) {
            this.options.setStreamOptions(streamOptions);
            return this;
        }

        public Builder streamUsage(boolean streamUsage) {
            this.options.setStreamOptions(StreamOptions.builder().from(this.options.getStreamOptions()).includeUsage(streamUsage).build());
            return this;
        }

        public Builder seed(Integer seed) {
            this.options.setSeed(seed);
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.setStop(stop);
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder topP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder toolChoice(Object toolChoice) {
            this.options.setToolChoice(toolChoice);
            return this;
        }

        public Builder user(String user) {
            this.options.setUser(user);
            return this;
        }

        public Builder parallelToolCalls(Boolean parallelToolCalls) {
            this.options.setParallelToolCalls(parallelToolCalls);
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            this.options.setToolCallbacks(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(new HashSet<String>(Arrays.asList(toolNames)));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            this.options.setToolContext(toolContext);
            return this;
        }

        public Builder store(Boolean store) {
            this.options.setStore(store);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.options.setMetadata(metadata);
            return this;
        }

        public Builder reasoningEffort(String reasoningEffort) {
            this.options.setReasoningEffort(reasoningEffort);
            return this;
        }

        public Builder verbosity(String verbosity) {
            this.options.setVerbosity(verbosity);
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.options.setServiceTier(serviceTier);
            return this;
        }

        public OpenAiSdkChatOptions build() {
            return this.options;
        }
    }
}

