/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openaisdk;

import com.openai.client.OpenAIClient;
import com.openai.models.images.ImageGenerateParams;
import com.openai.models.images.ImagesResponse;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageGenerationMetadata;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.ai.image.observation.DefaultImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationDocumentation;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.openaisdk.OpenAiSdkImageOptions;
import org.springframework.ai.openaisdk.metadata.OpenAiSdkImageGenerationMetadata;
import org.springframework.ai.openaisdk.metadata.OpenAiSdkImageResponseMetadata;
import org.springframework.ai.openaisdk.setup.OpenAiSdkSetup;
import org.springframework.util.Assert;

public class OpenAiSdkImageModel
implements ImageModel {
    private static final String DEFAULT_MODEL_NAME = OpenAiSdkImageOptions.DEFAULT_IMAGE_MODEL;
    private static final ImageModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultImageModelObservationConvention();
    private final Logger logger = LoggerFactory.getLogger(OpenAiSdkImageModel.class);
    private final OpenAIClient openAiClient;
    private final OpenAiSdkImageOptions options;
    private final ObservationRegistry observationRegistry;
    private ImageModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OpenAiSdkImageModel() {
        this(null, null, null);
    }

    public OpenAiSdkImageModel(OpenAiSdkImageOptions options) {
        this(null, options, null);
    }

    public OpenAiSdkImageModel(ObservationRegistry observationRegistry) {
        this(null, null, observationRegistry);
    }

    public OpenAiSdkImageModel(OpenAiSdkImageOptions options, ObservationRegistry observationRegistry) {
        this(null, options, observationRegistry);
    }

    public OpenAiSdkImageModel(OpenAIClient openAIClient) {
        this(openAIClient, null, null);
    }

    public OpenAiSdkImageModel(OpenAIClient openAIClient, OpenAiSdkImageOptions options) {
        this(openAIClient, options, null);
    }

    public OpenAiSdkImageModel(OpenAIClient openAIClient, ObservationRegistry observationRegistry) {
        this(openAIClient, null, observationRegistry);
    }

    public OpenAiSdkImageModel(OpenAIClient openAiClient, OpenAiSdkImageOptions options, ObservationRegistry observationRegistry) {
        this.options = options == null ? OpenAiSdkImageOptions.builder().model(DEFAULT_MODEL_NAME).build() : options;
        this.openAiClient = Objects.requireNonNullElseGet(openAiClient, () -> OpenAiSdkSetup.setupSyncClient(this.options.getBaseUrl(), this.options.getApiKey(), this.options.getCredential(), this.options.getMicrosoftDeploymentName(), this.options.getMicrosoftFoundryServiceVersion(), this.options.getOrganizationId(), this.options.isMicrosoftFoundry(), this.options.isGitHubModels(), this.options.getModel(), this.options.getTimeout(), this.options.getMaxRetries(), this.options.getProxy(), this.options.getCustomHeaders()));
        this.observationRegistry = Objects.requireNonNullElse(observationRegistry, ObservationRegistry.NOOP);
    }

    public OpenAiSdkImageOptions getOptions() {
        return this.options;
    }

    public ImageResponse call(ImagePrompt imagePrompt) {
        OpenAiSdkImageOptions options = OpenAiSdkImageOptions.builder().from(this.options).merge(imagePrompt.getOptions()).build();
        ImageGenerateParams imageGenerateParams = options.toOpenAiImageGenerateParams(imagePrompt);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("OpenAiSdkImageOptions call {} with the following options : {} ", (Object)options.getModel(), (Object)imageGenerateParams);
        }
        ImageModelObservationContext observationContext = ImageModelObservationContext.builder().imagePrompt(imagePrompt).provider(AiProvider.OPENAI_SDK.value()).build();
        return Objects.requireNonNull((ImageResponse)ImageModelObservationDocumentation.IMAGE_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ImagesResponse images = this.openAiClient.images().generate(imageGenerateParams);
            if (images.data().isEmpty() && ((List)images.data().get()).isEmpty()) {
                throw new IllegalArgumentException("Image generation failed: no image returned");
            }
            List<ImageGeneration> imageGenerations = ((List)images.data().get()).stream().map(nativeImage -> {
                Image image;
                if (nativeImage.url().isPresent()) {
                    image = new Image((String)nativeImage.url().get(), null);
                } else if (nativeImage.b64Json().isPresent()) {
                    image = new Image(null, (String)nativeImage.b64Json().get());
                } else {
                    throw new IllegalArgumentException("Image generation failed: image entry missing url and b64_json");
                }
                OpenAiSdkImageGenerationMetadata metadata = new OpenAiSdkImageGenerationMetadata(nativeImage.revisedPrompt());
                return new ImageGeneration(image, (ImageGenerationMetadata)metadata);
            }).toList();
            OpenAiSdkImageResponseMetadata openAiImageResponseMetadata = OpenAiSdkImageResponseMetadata.from(images);
            ImageResponse imageResponse = new ImageResponse(imageGenerations, (ImageResponseMetadata)openAiImageResponseMetadata);
            observationContext.setResponse((Object)imageResponse);
            return imageResponse;
        }));
    }

    public void setObservationConvention(ImageModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

