/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.management;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.ai.ollama.management.ModelManagementOptions;
import org.springframework.ai.ollama.management.PullModelStrategy;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.util.retry.Retry;

public class OllamaModelManager {
    private final Logger logger = LoggerFactory.getLogger(OllamaModelManager.class);
    private final OllamaApi ollamaApi;
    private final ModelManagementOptions options;

    public OllamaModelManager(OllamaApi ollamaApi) {
        this(ollamaApi, ModelManagementOptions.defaults());
    }

    public OllamaModelManager(OllamaApi ollamaApi, ModelManagementOptions options) {
        this.ollamaApi = ollamaApi;
        this.options = options;
        if (!CollectionUtils.isEmpty(options.additionalModels())) {
            options.additionalModels().forEach(this::pullModel);
        }
    }

    public boolean isModelAvailable(String modelName) {
        Assert.hasText((String)modelName, (String)"modelName must not be empty");
        OllamaApi.ListModelResponse listModelResponse = this.ollamaApi.listModels();
        if (!CollectionUtils.isEmpty(listModelResponse.models())) {
            String normalizedModelName = this.normalizeModelName(modelName);
            return listModelResponse.models().stream().anyMatch(m -> m.name().equals(normalizedModelName));
        }
        return false;
    }

    private String normalizeModelName(String modelName) {
        String modelNameWithoutSpaces = modelName.trim();
        if (modelNameWithoutSpaces.contains(":")) {
            return modelNameWithoutSpaces;
        }
        return modelNameWithoutSpaces + ":latest";
    }

    public void deleteModel(String modelName) {
        this.logger.info("Start deletion of model: {}", (Object)modelName);
        if (!this.isModelAvailable(modelName)) {
            this.logger.info("Model {} not found", (Object)modelName);
            return;
        }
        this.ollamaApi.deleteModel(new OllamaApi.DeleteModelRequest(modelName));
        this.logger.info("Completed deletion of model: {}", (Object)modelName);
    }

    public void pullModel(String modelName) {
        this.pullModel(modelName, this.options.pullModelStrategy());
    }

    public void pullModel(String modelName, PullModelStrategy pullModelStrategy) {
        if (PullModelStrategy.NEVER.equals((Object)pullModelStrategy)) {
            return;
        }
        if (PullModelStrategy.WHEN_MISSING.equals((Object)pullModelStrategy) && this.isModelAvailable(modelName)) {
            this.logger.debug("Model '{}' already available. Skipping pull operation.", (Object)modelName);
            return;
        }
        this.logger.info("Start pulling model: {}", (Object)modelName);
        this.ollamaApi.pullModel(new OllamaApi.PullModelRequest(modelName)).bufferUntilChanged(OllamaApi.ProgressResponse::status).doOnEach(signal -> {
            List progressResponses = (List)signal.get();
            if (!CollectionUtils.isEmpty((Collection)progressResponses) && progressResponses.get(progressResponses.size() - 1) != null) {
                this.logger.info("Pulling the '{}' model - Status: {}", (Object)modelName, (Object)((OllamaApi.ProgressResponse)progressResponses.get(progressResponses.size() - 1)).status());
            }
        }).takeUntil(progressResponses -> progressResponses.get(0) != null && ((OllamaApi.ProgressResponse)progressResponses.get(0)).status().equals("success")).timeout(this.options.timeout()).retryWhen((Retry)Retry.backoff((long)this.options.maxRetries().intValue(), (Duration)Duration.ofSeconds(5L))).blockLast();
        this.logger.info("Completed pulling the '{}' model", (Object)modelName);
    }
}

