/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.ollama.api.OllamaModel;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OllamaOptions
implements FunctionCallingOptions,
EmbeddingOptions {
    private static final List<String> NON_SUPPORTED_FIELDS = List.of("model", "format", "keep_alive", "truncate");
    @JsonProperty(value="numa")
    private Boolean useNUMA;
    @JsonProperty(value="num_ctx")
    private Integer numCtx;
    @JsonProperty(value="num_batch")
    private Integer numBatch;
    @JsonProperty(value="num_gpu")
    private Integer numGPU;
    @JsonProperty(value="main_gpu")
    private Integer mainGPU;
    @JsonProperty(value="low_vram")
    private Boolean lowVRAM;
    @JsonProperty(value="f16_kv")
    private Boolean f16KV;
    @JsonProperty(value="logits_all")
    private Boolean logitsAll;
    @JsonProperty(value="vocab_only")
    private Boolean vocabOnly;
    @JsonProperty(value="use_mmap")
    private Boolean useMMap;
    @JsonProperty(value="use_mlock")
    private Boolean useMLock;
    @JsonProperty(value="num_thread")
    private Integer numThread;
    @JsonProperty(value="num_keep")
    private Integer numKeep;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="num_predict")
    private Integer numPredict;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="tfs_z")
    private Float tfsZ;
    @JsonProperty(value="typical_p")
    private Float typicalP;
    @JsonProperty(value="repeat_last_n")
    private Integer repeatLastN;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="repeat_penalty")
    private Double repeatPenalty;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="mirostat")
    private Integer mirostat;
    @JsonProperty(value="mirostat_tau")
    private Float mirostatTau;
    @JsonProperty(value="mirostat_eta")
    private Float mirostatEta;
    @JsonProperty(value="penalize_newline")
    private Boolean penalizeNewline;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="keep_alive")
    private String keepAlive;
    @JsonProperty(value="truncate")
    private Boolean truncate;
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();
    @JsonIgnore
    private Boolean proxyToolCalls;
    @JsonIgnore
    private Map<String, Object> toolContext;

    public static OllamaOptions builder() {
        return new OllamaOptions();
    }

    public static OllamaOptions create() {
        return new OllamaOptions();
    }

    public static Map<String, Object> filterNonSupportedFields(Map<String, Object> options) {
        return options.entrySet().stream().filter(e -> !NON_SUPPORTED_FIELDS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static OllamaOptions fromOptions(OllamaOptions fromOptions) {
        return new OllamaOptions().withModel(fromOptions.getModel()).withFormat(fromOptions.getFormat()).withKeepAlive(fromOptions.getKeepAlive()).withTruncate(fromOptions.getTruncate()).withUseNUMA(fromOptions.getUseNUMA()).withNumCtx(fromOptions.getNumCtx()).withNumBatch(fromOptions.getNumBatch()).withNumGPU(fromOptions.getNumGPU()).withMainGPU(fromOptions.getMainGPU()).withLowVRAM(fromOptions.getLowVRAM()).withF16KV(fromOptions.getF16KV()).withLogitsAll(fromOptions.getLogitsAll()).withVocabOnly(fromOptions.getVocabOnly()).withUseMMap(fromOptions.getUseMMap()).withUseMLock(fromOptions.getUseMLock()).withNumThread(fromOptions.getNumThread()).withNumKeep(fromOptions.getNumKeep()).withSeed(fromOptions.getSeed()).withNumPredict(fromOptions.getNumPredict()).withTopK(fromOptions.getTopK()).withTopP(fromOptions.getTopP()).withTfsZ(fromOptions.getTfsZ()).withTypicalP(fromOptions.getTypicalP()).withRepeatLastN(fromOptions.getRepeatLastN()).withTemperature(fromOptions.getTemperature()).withRepeatPenalty(fromOptions.getRepeatPenalty()).withPresencePenalty(fromOptions.getPresencePenalty()).withFrequencyPenalty(fromOptions.getFrequencyPenalty()).withMirostat(fromOptions.getMirostat()).withMirostatTau(fromOptions.getMirostatTau()).withMirostatEta(fromOptions.getMirostatEta()).withPenalizeNewline(fromOptions.getPenalizeNewline()).withStop(fromOptions.getStop()).withFunctions(fromOptions.getFunctions()).withProxyToolCalls(fromOptions.getProxyToolCalls()).withFunctionCallbacks(fromOptions.getFunctionCallbacks()).withToolContext(fromOptions.getToolContext());
    }

    public OllamaOptions build() {
        return this;
    }

    public OllamaOptions withModel(String model) {
        this.model = model;
        return this;
    }

    public OllamaOptions withModel(OllamaModel model) {
        this.model = model.getName();
        return this;
    }

    public OllamaOptions withFormat(String format) {
        this.format = format;
        return this;
    }

    public OllamaOptions withKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public OllamaOptions withTruncate(Boolean truncate) {
        this.truncate = truncate;
        return this;
    }

    public OllamaOptions withUseNUMA(Boolean useNUMA) {
        this.useNUMA = useNUMA;
        return this;
    }

    public OllamaOptions withNumCtx(Integer numCtx) {
        this.numCtx = numCtx;
        return this;
    }

    public OllamaOptions withNumBatch(Integer numBatch) {
        this.numBatch = numBatch;
        return this;
    }

    public OllamaOptions withNumGPU(Integer numGPU) {
        this.numGPU = numGPU;
        return this;
    }

    public OllamaOptions withMainGPU(Integer mainGPU) {
        this.mainGPU = mainGPU;
        return this;
    }

    public OllamaOptions withLowVRAM(Boolean lowVRAM) {
        this.lowVRAM = lowVRAM;
        return this;
    }

    public OllamaOptions withF16KV(Boolean f16KV) {
        this.f16KV = f16KV;
        return this;
    }

    public OllamaOptions withLogitsAll(Boolean logitsAll) {
        this.logitsAll = logitsAll;
        return this;
    }

    public OllamaOptions withVocabOnly(Boolean vocabOnly) {
        this.vocabOnly = vocabOnly;
        return this;
    }

    public OllamaOptions withUseMMap(Boolean useMMap) {
        this.useMMap = useMMap;
        return this;
    }

    public OllamaOptions withUseMLock(Boolean useMLock) {
        this.useMLock = useMLock;
        return this;
    }

    public OllamaOptions withNumThread(Integer numThread) {
        this.numThread = numThread;
        return this;
    }

    public OllamaOptions withNumKeep(Integer numKeep) {
        this.numKeep = numKeep;
        return this;
    }

    public OllamaOptions withSeed(Integer seed) {
        this.seed = seed;
        return this;
    }

    public OllamaOptions withNumPredict(Integer numPredict) {
        this.numPredict = numPredict;
        return this;
    }

    public OllamaOptions withTopK(Integer topK) {
        this.topK = topK;
        return this;
    }

    public OllamaOptions withTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public OllamaOptions withTfsZ(Float tfsZ) {
        this.tfsZ = tfsZ;
        return this;
    }

    public OllamaOptions withTypicalP(Float typicalP) {
        this.typicalP = typicalP;
        return this;
    }

    public OllamaOptions withRepeatLastN(Integer repeatLastN) {
        this.repeatLastN = repeatLastN;
        return this;
    }

    public OllamaOptions withTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public OllamaOptions withRepeatPenalty(Double repeatPenalty) {
        this.repeatPenalty = repeatPenalty;
        return this;
    }

    public OllamaOptions withPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public OllamaOptions withFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public OllamaOptions withMirostat(Integer mirostat) {
        this.mirostat = mirostat;
        return this;
    }

    public OllamaOptions withMirostatTau(Float mirostatTau) {
        this.mirostatTau = mirostatTau;
        return this;
    }

    public OllamaOptions withMirostatEta(Float mirostatEta) {
        this.mirostatEta = mirostatEta;
        return this;
    }

    public OllamaOptions withPenalizeNewline(Boolean penalizeNewline) {
        this.penalizeNewline = penalizeNewline;
        return this;
    }

    public OllamaOptions withStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public OllamaOptions withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
        return this;
    }

    public OllamaOptions withFunctions(Set<String> functions) {
        this.functions = functions;
        return this;
    }

    public OllamaOptions withFunction(String functionName) {
        Assert.hasText((String)functionName, (String)"Function name must not be empty");
        this.functions.add(functionName);
        return this;
    }

    public OllamaOptions withProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
        return this;
    }

    public OllamaOptions withToolContext(Map<String, Object> toolContext) {
        if (this.toolContext == null) {
            this.toolContext = toolContext;
        } else {
            this.toolContext.putAll(toolContext);
        }
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getUseNUMA() {
        return this.useNUMA;
    }

    public void setUseNUMA(Boolean useNUMA) {
        this.useNUMA = useNUMA;
    }

    public Integer getNumCtx() {
        return this.numCtx;
    }

    public void setNumCtx(Integer numCtx) {
        this.numCtx = numCtx;
    }

    public Integer getNumBatch() {
        return this.numBatch;
    }

    public void setNumBatch(Integer numBatch) {
        this.numBatch = numBatch;
    }

    public Integer getNumGPU() {
        return this.numGPU;
    }

    public void setNumGPU(Integer numGPU) {
        this.numGPU = numGPU;
    }

    public Integer getMainGPU() {
        return this.mainGPU;
    }

    public void setMainGPU(Integer mainGPU) {
        this.mainGPU = mainGPU;
    }

    public Boolean getLowVRAM() {
        return this.lowVRAM;
    }

    public void setLowVRAM(Boolean lowVRAM) {
        this.lowVRAM = lowVRAM;
    }

    public Boolean getF16KV() {
        return this.f16KV;
    }

    public void setF16KV(Boolean f16kv) {
        this.f16KV = f16kv;
    }

    public Boolean getLogitsAll() {
        return this.logitsAll;
    }

    public void setLogitsAll(Boolean logitsAll) {
        this.logitsAll = logitsAll;
    }

    public Boolean getVocabOnly() {
        return this.vocabOnly;
    }

    public void setVocabOnly(Boolean vocabOnly) {
        this.vocabOnly = vocabOnly;
    }

    public Boolean getUseMMap() {
        return this.useMMap;
    }

    public void setUseMMap(Boolean useMMap) {
        this.useMMap = useMMap;
    }

    public Boolean getUseMLock() {
        return this.useMLock;
    }

    public void setUseMLock(Boolean useMLock) {
        this.useMLock = useMLock;
    }

    public Integer getNumThread() {
        return this.numThread;
    }

    public void setNumThread(Integer numThread) {
        this.numThread = numThread;
    }

    public Integer getNumKeep() {
        return this.numKeep;
    }

    public void setNumKeep(Integer numKeep) {
        this.numKeep = numKeep;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getNumPredict();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setNumPredict(maxTokens);
    }

    public Integer getNumPredict() {
        return this.numPredict;
    }

    public void setNumPredict(Integer numPredict) {
        this.numPredict = numPredict;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Float getTfsZ() {
        return this.tfsZ;
    }

    public void setTfsZ(Float tfsZ) {
        this.tfsZ = tfsZ;
    }

    public Float getTypicalP() {
        return this.typicalP;
    }

    public void setTypicalP(Float typicalP) {
        this.typicalP = typicalP;
    }

    public Integer getRepeatLastN() {
        return this.repeatLastN;
    }

    public void setRepeatLastN(Integer repeatLastN) {
        this.repeatLastN = repeatLastN;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getRepeatPenalty() {
        return this.repeatPenalty;
    }

    public void setRepeatPenalty(Double repeatPenalty) {
        this.repeatPenalty = repeatPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Integer getMirostat() {
        return this.mirostat;
    }

    public void setMirostat(Integer mirostat) {
        this.mirostat = mirostat;
    }

    public Float getMirostatTau() {
        return this.mirostatTau;
    }

    public void setMirostatTau(Float mirostatTau) {
        this.mirostatTau = mirostatTau;
    }

    public Float getMirostatEta() {
        return this.mirostatEta;
    }

    public void setMirostatEta(Float mirostatEta) {
        this.mirostatEta = mirostatEta;
    }

    public Boolean getPenalizeNewline() {
        return this.penalizeNewline;
    }

    public void setPenalizeNewline(Boolean penalizeNewline) {
        this.penalizeNewline = penalizeNewline;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Boolean getTruncate() {
        return this.truncate;
    }

    public void setTruncate(Boolean truncate) {
        this.truncate = truncate;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
    }

    @JsonIgnore
    public Integer getDimensions() {
        return null;
    }

    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public Map<String, Object> toMap() {
        return ModelOptionsUtils.objectToMap((Object)this);
    }

    public OllamaOptions copy() {
        return OllamaOptions.fromOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OllamaOptions that = (OllamaOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.format, that.format) && Objects.equals(this.keepAlive, that.keepAlive) && Objects.equals(this.truncate, that.truncate) && Objects.equals(this.useNUMA, that.useNUMA) && Objects.equals(this.numCtx, that.numCtx) && Objects.equals(this.numBatch, that.numBatch) && Objects.equals(this.numGPU, that.numGPU) && Objects.equals(this.mainGPU, that.mainGPU) && Objects.equals(this.lowVRAM, that.lowVRAM) && Objects.equals(this.f16KV, that.f16KV) && Objects.equals(this.logitsAll, that.logitsAll) && Objects.equals(this.vocabOnly, that.vocabOnly) && Objects.equals(this.useMMap, that.useMMap) && Objects.equals(this.useMLock, that.useMLock) && Objects.equals(this.numThread, that.numThread) && Objects.equals(this.numKeep, that.numKeep) && Objects.equals(this.seed, that.seed) && Objects.equals(this.numPredict, that.numPredict) && Objects.equals(this.topK, that.topK) && Objects.equals(this.topP, that.topP) && Objects.equals(this.tfsZ, that.tfsZ) && Objects.equals(this.typicalP, that.typicalP) && Objects.equals(this.repeatLastN, that.repeatLastN) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.repeatPenalty, that.repeatPenalty) && Objects.equals(this.presencePenalty, that.presencePenalty) && Objects.equals(this.frequencyPenalty, that.frequencyPenalty) && Objects.equals(this.mirostat, that.mirostat) && Objects.equals(this.mirostatTau, that.mirostatTau) && Objects.equals(this.mirostatEta, that.mirostatEta) && Objects.equals(this.penalizeNewline, that.penalizeNewline) && Objects.equals(this.stop, that.stop) && Objects.equals(this.functionCallbacks, that.functionCallbacks) && Objects.equals(this.proxyToolCalls, that.proxyToolCalls) && Objects.equals(this.functions, that.functions) && Objects.equals(this.toolContext, that.toolContext);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.format, this.keepAlive, this.truncate, this.useNUMA, this.numCtx, this.numBatch, this.numGPU, this.mainGPU, this.lowVRAM, this.f16KV, this.logitsAll, this.vocabOnly, this.useMMap, this.useMLock, this.numThread, this.numKeep, this.seed, this.numPredict, this.topK, this.topP, this.tfsZ, this.typicalP, this.repeatLastN, this.temperature, this.repeatPenalty, this.presencePenalty, this.frequencyPenalty, this.mirostat, this.mirostatTau, this.mirostatEta, this.penalizeNewline, this.stop, this.functionCallbacks, this.functions, this.proxyToolCalls, this.toolContext);
    }
}

