/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.oci;

import com.oracle.bmc.generativeaiinference.GenerativeAiInference;
import com.oracle.bmc.generativeaiinference.model.EmbedTextDetails;
import com.oracle.bmc.generativeaiinference.model.EmbedTextResult;
import com.oracle.bmc.generativeaiinference.model.ServingMode;
import com.oracle.bmc.generativeaiinference.requests.EmbedTextRequest;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.oci.OCIEmbeddingOptions;
import org.springframework.ai.oci.ServingModeHelper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OCIEmbeddingModel
extends AbstractEmbeddingModel {
    private static final int EMBEDTEXT_BATCH_SIZE = 96;
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final GenerativeAiInference genAi;
    private final OCIEmbeddingOptions options;
    private final ObservationRegistry observationRegistry;
    private final EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OCIEmbeddingModel(GenerativeAiInference genAi, OCIEmbeddingOptions options) {
        this(genAi, options, ObservationRegistry.NOOP);
    }

    public OCIEmbeddingModel(GenerativeAiInference genAi, OCIEmbeddingOptions options, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)genAi, (String)"com.oracle.bmc.generativeaiinference.GenerativeAiInferenceClient must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.genAi = genAi;
        this.options = options;
        this.observationRegistry = observationRegistry;
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        Assert.notEmpty((Collection)request.getInstructions(), (String)"At least one text is required!");
        EmbeddingRequest embeddingRequest = this.buildEmbeddingRequest(request);
        List<EmbedTextRequest> embedTextRequests = this.createRequests(embeddingRequest.getInstructions(), (OCIEmbeddingOptions)embeddingRequest.getOptions());
        EmbeddingModelObservationContext context = EmbeddingModelObservationContext.builder().embeddingRequest(embeddingRequest).provider(AiProvider.OCI_GENAI.value()).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> context, this.observationRegistry).observe(() -> this.embedAllWithContext(embedTextRequests, context));
    }

    public float[] embed(Document document) {
        return this.embed(document.getText());
    }

    private EmbeddingResponse embedAllWithContext(List<EmbedTextRequest> embedTextRequests, EmbeddingModelObservationContext context) {
        String modelId = null;
        AtomicInteger index = new AtomicInteger(0);
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        for (EmbedTextRequest embedTextRequest : embedTextRequests) {
            EmbedTextResult embedTextResult = this.genAi.embedText(embedTextRequest).getEmbedTextResult();
            if (modelId == null) {
                modelId = embedTextResult.getModelId();
            }
            for (List e : embedTextResult.getEmbeddings()) {
                float[] data = this.toFloats(e);
                embeddings.add(new Embedding(data, Integer.valueOf(index.getAndIncrement())));
            }
        }
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.setModel(modelId);
        metadata.setUsage((Usage)new EmptyUsage());
        EmbeddingResponse embeddingResponse = new EmbeddingResponse(embeddings, metadata);
        context.setResponse((Object)embeddingResponse);
        return embeddingResponse;
    }

    private List<EmbedTextRequest> createRequests(List<String> inputs, OCIEmbeddingOptions embeddingOptions) {
        int size = inputs.size();
        ArrayList<EmbedTextRequest> requests = new ArrayList<EmbedTextRequest>();
        for (int i = 0; i < inputs.size(); i += 96) {
            List<String> batch = inputs.subList(i, Math.min(i + 96, size));
            requests.add(this.createRequest(batch, embeddingOptions));
        }
        return requests;
    }

    private EmbedTextRequest createRequest(List<String> inputs, OCIEmbeddingOptions embeddingOptions) {
        ServingMode servingMode = ServingModeHelper.get(this.options.getServingMode(), this.options.getModel());
        EmbedTextDetails embedTextDetails = EmbedTextDetails.builder().servingMode(servingMode).compartmentId(embeddingOptions.getCompartment()).inputs(inputs).truncate(Objects.requireNonNullElse(embeddingOptions.getTruncate(), EmbedTextDetails.Truncate.End)).build();
        return EmbedTextRequest.builder().embedTextDetails(embedTextDetails).build();
    }

    private OCIEmbeddingOptions mergeOptions(EmbeddingOptions embeddingOptions, OCIEmbeddingOptions defaultOptions) {
        OCIEmbeddingOptions dynamicOptions;
        if (embeddingOptions instanceof OCIEmbeddingOptions && (dynamicOptions = (OCIEmbeddingOptions)ModelOptionsUtils.merge((Object)embeddingOptions, (Object)defaultOptions, OCIEmbeddingOptions.class)) != null) {
            return dynamicOptions;
        }
        return defaultOptions;
    }

    EmbeddingRequest buildEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        OCIEmbeddingOptions requestOptions;
        OCIEmbeddingOptions runtimeOptions = null;
        if (embeddingRequest.getOptions() != null) {
            runtimeOptions = (OCIEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)embeddingRequest.getOptions(), EmbeddingOptions.class, OCIEmbeddingOptions.class);
        }
        if (!StringUtils.hasText((String)(requestOptions = (OCIEmbeddingOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.options, OCIEmbeddingOptions.class)).getModel())) {
            throw new IllegalArgumentException("model cannot be null or empty");
        }
        return new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)requestOptions);
    }

    private float[] toFloats(List<Float> embedding) {
        float[] floats = new float[embedding.size()];
        for (int i = 0; i < embedding.size(); ++i) {
            floats[i] = embedding.get(i).floatValue();
        }
        return floats;
    }
}

