/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.oci.cohere;

import com.oracle.bmc.generativeaiinference.GenerativeAiInference;
import com.oracle.bmc.generativeaiinference.model.BaseChatRequest;
import com.oracle.bmc.generativeaiinference.model.BaseChatResponse;
import com.oracle.bmc.generativeaiinference.model.ChatDetails;
import com.oracle.bmc.generativeaiinference.model.CohereChatBotMessage;
import com.oracle.bmc.generativeaiinference.model.CohereChatRequest;
import com.oracle.bmc.generativeaiinference.model.CohereChatResponse;
import com.oracle.bmc.generativeaiinference.model.CohereMessage;
import com.oracle.bmc.generativeaiinference.model.CohereSystemMessage;
import com.oracle.bmc.generativeaiinference.model.CohereToolCall;
import com.oracle.bmc.generativeaiinference.model.CohereToolMessage;
import com.oracle.bmc.generativeaiinference.model.CohereToolResult;
import com.oracle.bmc.generativeaiinference.model.CohereUserMessage;
import com.oracle.bmc.generativeaiinference.model.ServingMode;
import com.oracle.bmc.generativeaiinference.requests.ChatRequest;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.oci.ServingModeHelper;
import org.springframework.ai.oci.cohere.OCICohereChatOptions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OCICohereChatModel
implements ChatModel {
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final Double DEFAULT_TEMPERATURE = 0.7;
    private final GenerativeAiInference genAi;
    private final OCICohereChatOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OCICohereChatModel(GenerativeAiInference genAi, OCICohereChatOptions options) {
        this(genAi, options, null);
    }

    public OCICohereChatModel(GenerativeAiInference genAi, OCICohereChatOptions options, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)genAi, (String)"com.oracle.bmc.generativeaiinference.GenerativeAiInference must not be null");
        Assert.notNull((Object)options, (String)"OCIChatOptions must not be null");
        this.genAi = genAi;
        this.defaultOptions = options;
        this.observationRegistry = observationRegistry;
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(requestPrompt).provider(AiProvider.OCI_GENAI.value()).build();
        return (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ChatResponse chatResponse = this.doChatRequest(prompt);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        OCICohereChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            runtimeOptions = (OCICohereChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, OCICohereChatOptions.class);
        }
        OCICohereChatOptions requestOptions = (OCICohereChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, OCICohereChatOptions.class);
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    public ChatOptions getDefaultOptions() {
        return OCICohereChatOptions.fromOptions(this.defaultOptions);
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    private ChatResponse doChatRequest(Prompt prompt) {
        OCICohereChatOptions options = this.mergeOptions(prompt.getOptions(), this.defaultOptions);
        this.validateChatOptions(options);
        ChatResponseMetadata metadata = ChatResponseMetadata.builder().model(options.getModel()).keyValue("compartment", (Object)options.getCompartment()).build();
        return new ChatResponse(this.getGenerations(prompt, options), metadata);
    }

    private OCICohereChatOptions mergeOptions(ChatOptions chatOptions, OCICohereChatOptions defaultOptions) {
        OCICohereChatOptions override;
        OCICohereChatOptions dynamicOptions;
        if (chatOptions instanceof OCICohereChatOptions && (dynamicOptions = (OCICohereChatOptions)ModelOptionsUtils.merge((Object)(override = (OCICohereChatOptions)chatOptions), (Object)defaultOptions, OCICohereChatOptions.class)) != null) {
            return dynamicOptions;
        }
        return defaultOptions;
    }

    private void validateChatOptions(OCICohereChatOptions options) {
        if (!StringUtils.hasText((String)options.getModel())) {
            throw new IllegalArgumentException("Model is not set!");
        }
        if (!StringUtils.hasText((String)options.getCompartment())) {
            throw new IllegalArgumentException("Compartment is not set!");
        }
        if (!StringUtils.hasText((String)options.getServingMode())) {
            throw new IllegalArgumentException("ServingMode is not set!");
        }
    }

    private List<Generation> getGenerations(Prompt prompt, OCICohereChatOptions options) {
        com.oracle.bmc.generativeaiinference.responses.ChatResponse cr = this.genAi.chat(this.toCohereChatRequest(prompt, options));
        return this.toGenerations(cr, options);
    }

    private List<Generation> toGenerations(com.oracle.bmc.generativeaiinference.responses.ChatResponse ociChatResponse, OCICohereChatOptions options) {
        BaseChatResponse cr = ociChatResponse.getChatResult().getChatResponse();
        if (cr instanceof CohereChatResponse) {
            CohereChatResponse resp = (CohereChatResponse)cr;
            ArrayList<Generation> generations = new ArrayList<Generation>();
            ChatGenerationMetadata metadata = ChatGenerationMetadata.builder().finishReason(resp.getFinishReason().getValue()).build();
            AssistantMessage message = AssistantMessage.builder().content(resp.getText()).properties(Map.of()).build();
            generations.add(new Generation(message, metadata));
            return generations;
        }
        throw new IllegalStateException(String.format("Unexpected chat response type: %s", cr.getClass().getName()));
    }

    private ChatRequest toCohereChatRequest(Prompt prompt, OCICohereChatOptions options) {
        List messages = prompt.getInstructions();
        Message message = (Message)messages.get(0);
        List<CohereMessage> chatHistory = this.getCohereMessages(messages);
        return this.newChatRequest(options, message, chatHistory);
    }

    private List<CohereMessage> getCohereMessages(List<Message> messages) {
        ArrayList<CohereMessage> chatHistory = new ArrayList<CohereMessage>();
        block6: for (int i = 1; i < messages.size(); ++i) {
            Message message = messages.get(i);
            switch (message.getMessageType()) {
                case USER: {
                    chatHistory.add((CohereMessage)CohereUserMessage.builder().message(message.getText()).build());
                    continue block6;
                }
                case ASSISTANT: {
                    chatHistory.add((CohereMessage)CohereChatBotMessage.builder().message(message.getText()).build());
                    continue block6;
                }
                case SYSTEM: {
                    chatHistory.add((CohereMessage)CohereSystemMessage.builder().message(message.getText()).build());
                    continue block6;
                }
                case TOOL: {
                    if (!(message instanceof ToolResponseMessage)) continue block6;
                    ToolResponseMessage tm = (ToolResponseMessage)message;
                    chatHistory.add((CohereMessage)this.toToolMessage(tm));
                }
            }
        }
        return chatHistory;
    }

    private CohereToolMessage toToolMessage(ToolResponseMessage tm) {
        List<CohereToolResult> results = tm.getResponses().stream().map(r -> {
            CohereToolCall call = CohereToolCall.builder().name(r.name()).build();
            return CohereToolResult.builder().call(call).outputs(List.of(r.responseData())).build();
        }).toList();
        return CohereToolMessage.builder().toolResults(results).build();
    }

    private ChatRequest newChatRequest(OCICohereChatOptions options, Message message, List<CohereMessage> chatHistory) {
        CohereChatRequest baseChatRequest = CohereChatRequest.builder().frequencyPenalty(options.getFrequencyPenalty()).presencePenalty(options.getPresencePenalty()).maxTokens(options.getMaxTokens()).topK(options.getTopK()).topP(options.getTopP()).temperature(Objects.requireNonNullElse(options.getTemperature(), DEFAULT_TEMPERATURE)).preambleOverride(options.getPreambleOverride()).stopSequences(options.getStopSequences()).documents(options.getDocuments()).tools(options.getTools()).chatHistory(chatHistory).message(message.getText()).build();
        ServingMode servingMode = ServingModeHelper.get(options.getServingMode(), options.getModel());
        ChatDetails chatDetails = ChatDetails.builder().compartmentId(options.getCompartment()).servingMode(servingMode).chatRequest((BaseChatRequest)baseChatRequest).build();
        return ChatRequest.builder().body$(chatDetails).build();
    }
}

