/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.mongodb.atlas;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class MongoDBAtlasFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        if (Filter.ExpressionType.AND.equals((Object)expression.type()) || Filter.ExpressionType.OR.equals((Object)expression.type())) {
            this.doCompoundExpressionType(expression, context);
        } else {
            this.doSingleExpressionType(expression, context);
        }
    }

    private void doCompoundExpressionType(Filter.Expression expression, StringBuilder context) {
        context.append("{");
        context.append(this.getOperationSymbol(expression));
        context.append(":[");
        this.convertOperand(expression.left(), context);
        context.append(",");
        this.convertOperand(expression.right(), context);
        context.append("]}");
    }

    private void doSingleExpressionType(Filter.Expression expression, StringBuilder context) {
        context.append("{");
        this.convertOperand(expression.left(), context);
        context.append(":{");
        context.append(this.getOperationSymbol(expression));
        context.append(":");
        this.convertOperand(expression.right(), context);
        context.append("}}");
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> "$and";
            case Filter.ExpressionType.OR -> "$or";
            case Filter.ExpressionType.EQ -> "$eq";
            case Filter.ExpressionType.NE -> "$ne";
            case Filter.ExpressionType.LT -> "$lt";
            case Filter.ExpressionType.LTE -> "$lte";
            case Filter.ExpressionType.GT -> "$gt";
            case Filter.ExpressionType.GTE -> "$gte";
            case Filter.ExpressionType.IN -> "$in";
            case Filter.ExpressionType.NIN -> "$nin";
            default -> throw new RuntimeException("Not supported expression type:" + String.valueOf(exp.type()));
        };
    }

    protected void doKey(Filter.Key filterKey, StringBuilder context) {
        String identifier = this.hasOuterQuotes(filterKey.key()) ? this.removeOuterQuotes(filterKey.key()) : filterKey.key();
        context.append("\"metadata." + identifier + "\"");
    }
}

